"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlIndex = void 0;
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _esqlUtils = require("@kbn/esql-utils");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _utils = require("../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * parses ES|QL query and returns memoized array of indices
 * @param query - ES|QL query to retrieve indices from
 * @param ruleType - rule type value
 * @returns string[] - array of indices. Array is empty if query is invalid or ruleType is not 'esql'.
 */
const useEsqlIndex = (query, ruleType) => {
  const [debouncedQuery, setDebouncedQuery] = (0, _react.useState)(query);
  (0, _useDebounce.default)(() => {
    /*
      Triggerring the ES|QL parser a few moments after the user has finished typing 
      to avoid unnecessary calls to the parser.
    */
    setDebouncedQuery(query);
  }, 300, [query]);
  const indexString = (0, _react.useMemo)(() => {
    const esqlQuery = typeof debouncedQuery === 'string' && (0, _utils.isEsqlRule)(ruleType) ? debouncedQuery : undefined;
    try {
      return (0, _esqlUtils.getIndexPatternFromESQLQuery)(esqlQuery);
    } catch (error) {
      /*
        Some invalid queries cause ES|QL parser to throw a TypeError.
        Treating such cases as if parser returned an empty string.
      */
      return '';
    }
  }, [debouncedQuery, ruleType]);
  const index = (0, _react.useMemo)(() => (0, _securitysolutionUtils.getIndexListFromIndexString)(indexString), [indexString]);
  return index;
};
exports.useEsqlIndex = useEsqlIndex;