"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourcererAdapterSelector = exports.signalIndexOutdatedSelector = exports.signalIndexNameSelector = exports.sharedStateSelector = void 0;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourcererAdapterSelector = scope => (0, _toolkit.createSelector)([state => state.dataViewManager], dataViewManager => {
  const scopedState = dataViewManager[scope];
  return {
    ...scopedState
  };
});
exports.sourcererAdapterSelector = sourcererAdapterSelector;
const sharedStateSelector = exports.sharedStateSelector = (0, _toolkit.createSelector)([state => state.dataViewManager], dataViewManager => dataViewManager.shared);

// NOTE: This will be subject to cleanup tasks https://github.com/elastic/security-team/issues/11959
const signalIndexNameSelector = exports.signalIndexNameSelector = (0, _toolkit.createSelector)([state => state.dataViewManager], dataViewManager => {
  var _dataViewManager$shar, _dataViewManager$shar2;
  return (_dataViewManager$shar = (_dataViewManager$shar2 = dataViewManager.shared.signalIndex) === null || _dataViewManager$shar2 === void 0 ? void 0 : _dataViewManager$shar2.name) !== null && _dataViewManager$shar !== void 0 ? _dataViewManager$shar : '';
});

// NOTE: This will be subject to cleanup tasks https://github.com/elastic/security-team/issues/11959
const signalIndexOutdatedSelector = exports.signalIndexOutdatedSelector = (0, _toolkit.createSelector)([state => state.dataViewManager], dataViewManager => {
  var _dataViewManager$shar3;
  return !!((_dataViewManager$shar3 = dataViewManager.shared.signalIndex) !== null && _dataViewManager$shar3 !== void 0 && _dataViewManager$shar3.isOutdated);
});