"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlGlobalFilterQuery = void 0;
var _react = require("react");
var _use_global_time = require("../../containers/use_global_time");
var _use_global_filter_query = require("../use_global_filter_query");
var _kuery = require("../../lib/kuery");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEsqlGlobalFilterQuery = () => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const extraFilter = (0, _react.useMemo)(() => (0, _kuery.buildTimeRangeFilter)(from, to), [from, to]);
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)({
    extraFilter
  });
  return filterQuery;
};
exports.useEsqlGlobalFilterQuery = useEsqlGlobalFilterQuery;