"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineFullScreen = exports.useHasFullScreenContent = exports.useHasDataGridFullScreen = exports.useGlobalFullScreen = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../store/inputs/constants");
var _constants2 = require("../../../../common/constants");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
var _actions = require("../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGlobalFullScreen = () => {
  var _useShallowEqualSelec;
  const dispatch = (0, _reactRedux.useDispatch)();
  const globalFullScreen = (_useShallowEqualSelec = (0, _use_selector.useShallowEqualSelector)(_store.inputsSelectors.globalFullScreenSelector)) !== null && _useShallowEqualSelec !== void 0 ? _useShallowEqualSelec : false;
  const setGlobalFullScreen = (0, _react.useCallback)(fullScreen => {
    const isDataGridFullScreen = document.querySelector('.euiDataGrid--fullScreen') !== null;
    if (fullScreen) {
      document.body.classList.add(_constants2.SCROLLING_DISABLED_CLASS_NAME, 'euiDataGrid__restrictBody');
    } else if (isDataGridFullScreen === false || fullScreen === false) {
      document.body.classList.remove(_constants2.SCROLLING_DISABLED_CLASS_NAME, 'euiDataGrid__restrictBody');
    }
    dispatch(_actions.inputsActions.setFullScreen({
      id: _constants.InputsModelId.global,
      fullScreen
    }));
  }, [dispatch]);
  const memoizedReturn = (0, _react.useMemo)(() => ({
    globalFullScreen,
    setGlobalFullScreen
  }), [globalFullScreen, setGlobalFullScreen]);
  return memoizedReturn;
};
exports.useGlobalFullScreen = useGlobalFullScreen;
const useTimelineFullScreen = () => {
  var _useShallowEqualSelec2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const timelineFullScreen = (_useShallowEqualSelec2 = (0, _use_selector.useShallowEqualSelector)(_store.inputsSelectors.timelineFullScreenSelector)) !== null && _useShallowEqualSelec2 !== void 0 ? _useShallowEqualSelec2 : false;
  const setTimelineFullScreen = (0, _react.useCallback)(fullScreen => {
    const isDataGridFullScreen = document.querySelector('.euiDataGrid--fullScreen') !== null;
    if (fullScreen) {
      document.body.classList.add('euiDataGrid__restrictBody');
    } else if (isDataGridFullScreen === false || fullScreen === false) {
      document.body.classList.remove('euiDataGrid__restrictBody');
    }
    dispatch(_actions.inputsActions.setFullScreen({
      id: _constants.InputsModelId.timeline,
      fullScreen
    }));
  }, [dispatch]);
  const memoizedReturn = (0, _react.useMemo)(() => ({
    timelineFullScreen,
    setTimelineFullScreen
  }), [timelineFullScreen, setTimelineFullScreen]);
  return memoizedReturn;
};

/**
 * Checks to see if there is a EUI Data Grid in full screen mode in the document tree
 */
exports.useTimelineFullScreen = useTimelineFullScreen;
const useHasDataGridFullScreen = () => {
  const [isDataGridFullScreen, setIsDataGridFullScreen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const observeTarget = document.body;
    const docBodyObserver = new MutationObserver(changes => {
      for (const change of changes) {
        if (change.attributeName === 'class') {
          setIsDataGridFullScreen(observeTarget.classList.contains('euiDataGrid__restrictBody'));
        }
      }
    });
    docBodyObserver.observe(observeTarget, {
      attributes: true
    });
    return () => docBodyObserver.disconnect();
  }, []);
  return isDataGridFullScreen;
};

/**
 * Checks to see if any content (ex. timeline, global or data grid) is
 * currently being displayed in full screen mode
 */
exports.useHasDataGridFullScreen = useHasDataGridFullScreen;
const useHasFullScreenContent = () => {
  const {
    globalFullScreen
  } = useGlobalFullScreen();
  const {
    timelineFullScreen
  } = useTimelineFullScreen();
  const dataGridFullScreen = useHasDataGridFullScreen();
  return globalFullScreen || timelineFullScreen || dataGridFullScreen;
};
exports.useHasFullScreenContent = useHasFullScreenContent;