"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _common = require("../../../../../common");
var _breadcrumbs = require("../../../../explore/hosts/pages/details/breadcrumbs");
var _breadcrumbs2 = require("../../../../explore/network/pages/details/breadcrumbs");
var _breadcrumbs3 = require("../../../../detection_engine/common/breadcrumbs");
var _breadcrumbs4 = require("../../../../exceptions/utils/breadcrumbs");
var _breadcrumbs5 = require("../../../../cloud_security_posture/breadcrumbs");
var _breadcrumbs6 = require("../../../../explore/users/pages/details/breadcrumbs");
var _breadcrumbs7 = require("../../../../dashboards/pages/breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTrailingBreadcrumbs = (spyState, getSecuritySolutionUrl) => {
  switch (spyState.pageName) {
    case _common.SecurityPageName.hosts:
      return (0, _breadcrumbs.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _common.SecurityPageName.network:
      return (0, _breadcrumbs2.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _common.SecurityPageName.users:
      return (0, _breadcrumbs6.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _common.SecurityPageName.rules:
    case _common.SecurityPageName.rulesAdd:
    case _common.SecurityPageName.rulesCreate:
      return (0, _breadcrumbs3.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _common.SecurityPageName.exceptions:
      return (0, _breadcrumbs4.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _common.SecurityPageName.cloudSecurityPostureBenchmarks:
      return (0, _breadcrumbs5.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _common.SecurityPageName.dashboards:
      return (0, _breadcrumbs7.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
  }
  return [];
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;