"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkFromInfluencers = void 0;
var _types = require("../types");
var _get_entries = require("../get_entries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNetworkFromInfluencers = (influencers = [], ip) => {
  const recordFound = influencers.find(influencer => {
    const [influencerName, influencerValue] = (0, _get_entries.getEntries)(influencer);
    if ((0, _types.isDestinationOrSource)(influencerName)) {
      if (ip == null) {
        return true;
      } else {
        return influencerValue === ip;
      }
    } else {
      return false;
    }
  });
  if (recordFound != null) {
    const [influencerName] = (0, _get_entries.getEntries)(recordFound);
    if ((0, _types.isDestinationOrSource)(influencerName)) {
      return {
        ip: Object.values(recordFound)[0],
        type: influencerName
      };
    } else {
      // default to destination.ip
      return {
        ip: Object.values(recordFound)[0],
        type: 'destination.ip'
      };
    }
  } else {
    return null;
  }
};
exports.getNetworkFromInfluencers = getNetworkFromInfluencers;