"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInsightQuery = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _constants = require("../../../../../data_view_manager/constants");
var _use_experimental_features = require("../../../../hooks/use_experimental_features");
var _timeline = require("../../../../../../common/types/timeline");
var _kibana = require("../../../../lib/kibana");
var _kuery = require("../../../../lib/kuery");
var _containers = require("../../../../../timelines/containers");
var _containers2 = require("../../../../../sourcerer/containers");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _use_browser_fields = require("../../../../../data_view_manager/hooks/use_browser_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fields = ['*'];
const runtimeMappings = {};
const useInsightQuery = ({
  dataProviders,
  filters,
  relativeTimerange
}) => {
  var _experimentalDataView;
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const {
    browserFields: oldBrowserFields,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView,
    dataViewId: oldDataViewId
  } = (0, _containers2.useSourcererDataView)(_constants.PageScope.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants.PageScope.timeline);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.PageScope.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_constants.PageScope.timeline);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const dataViewId = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : oldDataViewId;
  const [hasError, setHasError] = (0, _react.useState)(false);
  const combinedQueries = (0, _react.useMemo)(() => {
    try {
      if (hasError === false) {
        const parsedCombinedQueries = (0, _kuery.combineQueries)({
          config: esQueryConfig,
          dataProviders,
          dataViewSpec: oldSourcererDataView,
          dataView: experimentalDataView,
          browserFields,
          filters,
          kqlQuery: {
            query: '',
            language: 'kuery'
          },
          kqlMode: 'filter'
        });
        return parsedCombinedQueries;
      }
    } catch (err) {
      setHasError(true);
      return null;
    }
  }, [hasError, esQueryConfig, dataProviders, oldSourcererDataView, experimentalDataView, browserFields, filters]);
  const [dataLoadingState, {
    events,
    totalCount
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    fields,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    id: _timeline.TimelineId.active,
    indexNames: selectedPatterns,
    language: 'kuery',
    limit: 1,
    runtimeMappings,
    startDate: relativeTimerange === null || relativeTimerange === void 0 ? void 0 : relativeTimerange.from,
    endDate: relativeTimerange === null || relativeTimerange === void 0 ? void 0 : relativeTimerange.to,
    fetchNotes: false
  });
  const isQueryLoading = (0, _react.useMemo)(() => [_unifiedDataTable.DataLoadingState.loading, _unifiedDataTable.DataLoadingState.loadingMore].includes(dataLoadingState), [dataLoadingState]);
  const [oldestEvent] = events;
  const timestamp = oldestEvent && oldestEvent.data && oldestEvent.data.find(d => d.field === '@timestamp');
  const oldestTimestamp = timestamp && timestamp.value && timestamp.value[0];
  return {
    isQueryLoading,
    totalCount,
    oldestTimestamp,
    hasError
  };
};
exports.useInsightQuery = useInsightQuery;