"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _plugins = require("./plugins");
var _use_upselling = require("../../hooks/use_upselling");
var _user_privileges = require("../user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MarkdownEditorComponent = /*#__PURE__*/(0, _react.forwardRef)(({
  onChange,
  value,
  ariaLabel,
  editorId,
  dataTestSubj,
  height,
  autoFocusDisabled,
  setIsMarkdownInvalid,
  includePlugins = true,
  placeholder
}, ref) => {
  const [markdownErrorMessages, setMarkdownErrorMessages] = (0, _react.useState)([]);
  const onParse = (0, _react.useCallback)((err, {
    messages
  }) => {
    setMarkdownErrorMessages(err ? [err] : messages);
    setIsMarkdownInvalid(err ? true : false);
  }, [setIsMarkdownInvalid]);
  const editorRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!autoFocusDisabled) {
      var _editorRef$current, _editorRef$current$te;
      (_editorRef$current = editorRef.current) === null || _editorRef$current === void 0 ? void 0 : (_editorRef$current$te = _editorRef$current.textarea) === null || _editorRef$current$te === void 0 ? void 0 : _editorRef$current$te.focus();
    }
  }, [autoFocusDisabled]);
  const insightsUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('investigation_guide');
  const interactionsUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('investigation_guide_interactions');
  const {
    timelinePrivileges: {
      read: canSeeTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const uiPluginsWithState = (0, _react.useMemo)(() => {
    return includePlugins ? (0, _plugins.uiPlugins)({
      insightsUpsellingMessage,
      interactionsUpsellingMessage,
      canSeeTimeline
    }) : undefined;
  }, [includePlugins, canSeeTimeline, insightsUpsellingMessage, interactionsUpsellingMessage]);

  // @ts-expect-error update types
  (0, _react.useImperativeHandle)(ref, () => {
    var _editorRef$current2, _editorRef$current2$t;
    if (!editorRef.current) {
      return null;
    }
    const editorNode = (_editorRef$current2 = editorRef.current) === null || _editorRef$current2 === void 0 ? void 0 : (_editorRef$current2$t = _editorRef$current2.textarea) === null || _editorRef$current2$t === void 0 ? void 0 : _editorRef$current2$t.closest('.euiMarkdownEditor');
    return {
      ...editorRef.current,
      toolbar: editorNode === null || editorNode === void 0 ? void 0 : editorNode.querySelector('.euiMarkdownEditorToolbar')
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    ref: editorRef,
    "aria-label": ariaLabel,
    editorId: editorId,
    onChange: onChange,
    value: value,
    uiPlugins: uiPluginsWithState,
    parsingPluginList: _plugins.parsingPlugins,
    processingPluginList: _plugins.processingPlugins,
    onParse: onParse,
    errors: markdownErrorMessages,
    "data-test-subj": dataTestSubj,
    height: height,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  });
});
MarkdownEditorComponent.displayName = 'MarkdownEditorComponent';
const MarkdownEditor = exports.MarkdownEditor = /*#__PURE__*/(0, _react.memo)(MarkdownEditorComponent);