"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProviderContentWrapper = exports.Content = exports.CellActionsRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _types = require("../../../../common/types");
var _ = require(".");
var _helpers = require("../../../helpers");
var _context = require("../../../timelines/components/timeline/context");
var _truncatable_text = require("../truncatable_text");
var _shared = require("../events_viewer/shared");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/cell_actions/cell_actions_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProviderContentWrapper = exports.ProviderContentWrapper = _styled.default.span`
  > span.euiToolTipAnchor {
    display: block; /* allow EuiTooltip content to be truncatable */
  }

  > span.euiToolTipAnchor.eui-textTruncate {
    display: inline-block; /* do not override display when a tooltip is truncated via eui-textTruncate */
  }
`;
/**
 * Renders the content of the cell actions, wrapped in a tooltip
 */
const Content = exports.Content = /*#__PURE__*/_react.default.memo(({
  children,
  field,
  tooltipContent,
  tooltipPosition,
  value
}) => !(0, _utils.tooltipContentIsExplicitlyNull)(tooltipContent) ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": `${field}-tooltip`,
  position: tooltipPosition,
  content: (0, _utils.getDefaultWhenTooltipIsUnspecified)({
    tooltipContent,
    field
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children ? children : value)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children ? children : value));
Content.displayName = 'Content';

/**
 * Renders cell actions content (or an arbitrary visualization specified by `children`)
 * that's only displayed when the specified value is non-`null`.
 * @param field - the name of the field, e.g. `network.transport`
 * @param value - value of the field e.g. `tcp`
 * @param children - defaults to displaying `value`, this allows an arbitrary visualization to be displayed in lieu of the default behavior
 * @param tooltipContent - defaults to displaying `field`, pass `null` to
 * prevent a tooltip from being displayed, or pass arbitrary content
 * @param tooltipPosition - defaults to eui's default tooltip position
 * @param queryValue - defaults to `value`, this query overrides the `queryMatch.value` used by the `DataProvider` that represents the data
 * @param hideTopN - defaults to `false`, when true, the option to aggregate this field will be hidden
 * @param scopeId - the id of the scope, e.g. `timelineId` or `tableId`
 * @param truncate - defaults to `false`, when true, the content will be truncated
 */
const CellActionsRenderer = exports.CellActionsRenderer = /*#__PURE__*/_react.default.memo(({
  hideTopN = false,
  field,
  value,
  children,
  scopeId = _types.TimelineId.active,
  tooltipContent,
  tooltipPosition,
  queryValue,
  truncate = false
}) => {
  const {
    timelineId: timelineIdFind
  } = (0, _react.useContext)(_context.TimelineContext);
  const {
    tableId: tableIdFind
  } = (0, _react.useContext)(_shared.TableContext);
  const sourcererScopeId = (0, _react.useMemo)(() => {
    var _ref;
    return (0, _helpers.getSourcererScopeId)((_ref = scopeId !== null && scopeId !== void 0 ? scopeId : timelineIdFind) !== null && _ref !== void 0 ? _ref : tableIdFind);
  }, [scopeId, tableIdFind, timelineIdFind]);
  const data = (0, _react.useMemo)(() => {
    if (queryValue) {
      return {
        value: queryValue,
        field
      };
    }
    return {
      value: value || [],
      field
    };
  }, [value, field, queryValue]);
  const disabledActionTypes = (0, _react.useMemo)(() => hideTopN ? [_.SecurityCellActionType.SHOW_TOP_N] : [], [hideTopN]);
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: -1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "render-truncatable-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Content, {
    field: field,
    tooltipContent: tooltipContent,
    tooltipPosition: tooltipPosition,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }, children)) : /*#__PURE__*/_react.default.createElement(ProviderContentWrapper, {
    "data-test-subj": `render-content-${field}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Content, {
    field: field,
    tooltipContent: tooltipContent,
    tooltipPosition: tooltipPosition,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, children))), [children, field, truncate, tooltipContent, tooltipPosition, value]);
  if (value == null) return null;
  if ((0, _utils.disableHoverActions)(scopeId)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
  }
  return /*#__PURE__*/_react.default.createElement(_.SecurityCellActions, {
    mode: _.CellActionsMode.HOVER_DOWN,
    visibleCellActions: 6,
    showActionTooltips: true,
    triggerId: _.SecurityCellActionsTrigger.DEFAULT,
    data: data,
    disabledActionTypes: disabledActionTypes,
    sourcererScopeId: sourcererScopeId,
    metadata: {
      scopeId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, content);
});
CellActionsRenderer.displayName = 'CellActionsRenderer';