"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSchema = void 0;
var _i18n = require("@kbn/i18n");
var _validate_rule_actions_field = require("../../../../../common/containers/rule_actions/validate_rule_actions_field");
var _shared_imports = require("../../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const getSchema = ({
  actionTypeRegistry,
  connectors
}) => ({
  name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.fieldNameLabel', {
      defaultMessage: 'Name'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.nameFieldRequiredError', {
        defaultMessage: 'A name is required.'
      }))
    }]
  },
  connectorId: {
    label: _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.fieldConnectorIdLabel', {
      defaultMessage: 'Connector'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.fieldConnectorIdHelpText', {
      defaultMessage: 'This connector will apply to this schedule, only.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.connectorIdFieldRequiredError', {
        defaultMessage: 'A connector is required.'
      }))
    }]
  },
  alertsSelectionSettings: {},
  interval: {
    label: _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.fieldIntervalLabel', {
      defaultMessage: 'Runs every'
    })
  },
  actions: {
    validations: [{
      // Debounced validator is necessary here to prevent error validation
      // flashing when first adding an action. Also prevents additional renders
      validator: (0, _validate_rule_actions_field.debouncedValidateRuleActionsField)(actionTypeRegistry, connectors)
    }]
  }
});
exports.getSchema = getSchema;