"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionDenied = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _entity_store_missing_privileges_callout = require("../../../entity_analytics/components/entity_store/components/entity_store_missing_privileges_callout");
var _lock_light = _interopRequireDefault(require("../../../common/images/lock_light.png"));
var _centered_wrapper = require("./centered_wrapper");
var _empty_state_illustration_container = require("../empty_state_illustration_container");
var _constants = require("../../constants");
var _need_help = require("./need_help");
var _asset_inventory_title = require("../asset_inventory_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/onboarding/permission_denied.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PermissionDenied = ({
  privileges
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_centered_wrapper.CenteredWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _constants.TEST_SUBJ_ONBOARDING_PERMISSION_DENIED,
    icon: /*#__PURE__*/_react.default.createElement(_empty_state_illustration_container.EmptyStateIllustrationContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: _lock_light.default,
      size: "fullWidth",
      alt: _i18n.i18n.translate('xpack.securitySolution.assetInventory.permissionDenied.illustrationAlt', {
        defaultMessage: 'Permission Denied'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 17
      }
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.permissionDenied.title",
      defaultMessage: "Permission Denied",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 17
      }
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.permissionDenied.description",
      defaultMessage: "You do not have the necessary permissions to enable or view the Asset Inventory. To access this feature, please contact your administrator to request the appropriate permissions.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 19
      }
    })), privileges ? /*#__PURE__*/_react.default.createElement(_entity_store_missing_privileges_callout.EntityStoreMissingPrivilegesCallout, {
      privileges: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 19
      }
    }) : null),
    footer: /*#__PURE__*/_react.default.createElement(_need_help.NeedHelp, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  }))));
};
exports.PermissionDenied = PermissionDenied;