"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesV3Feature = exports.getCasesV2Feature = exports.getCasesFeature = void 0;
var _kibana_features = require("./v1_features/kibana_features");
var _kibana_sub_features = require("./v1_features/kibana_sub_features");
var _kibana_features2 = require("./v2_features/kibana_features");
var _kibana_sub_features2 = require("./v2_features/kibana_sub_features");
var _kibana_features3 = require("./v3_features/kibana_features");
var _kibana_sub_features3 = require("./v3_features/kibana_sub_features");
var _product_feature_config = require("./product_feature_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesFeature = params => ({
  baseKibanaFeature: (0, _kibana_features.getCasesBaseKibanaFeature)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features.getCasesBaseKibanaSubFeatureIdsV1)(),
  subFeaturesMap: (0, _kibana_sub_features.getCasesSubFeaturesMapV1)(params),
  productFeatureConfig: (0, _product_feature_config.getCasesProductFeaturesConfig)(params)
});
exports.getCasesFeature = getCasesFeature;
const getCasesV2Feature = params => ({
  baseKibanaFeature: (0, _kibana_features2.getCasesBaseKibanaFeatureV2)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features2.getCasesBaseKibanaSubFeatureIdsV2)(),
  subFeaturesMap: (0, _kibana_sub_features2.getCasesSubFeaturesMapV2)(params),
  productFeatureConfig: (0, _product_feature_config.getCasesProductFeaturesConfig)(params)
});
exports.getCasesV2Feature = getCasesV2Feature;
const getCasesV3Feature = params => ({
  baseKibanaFeature: (0, _kibana_features3.getCasesBaseKibanaFeatureV3)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features3.getCasesBaseKibanaSubFeatureIdsV3)(),
  subFeaturesMap: (0, _kibana_sub_features3.getCasesSubFeaturesMapV3)(params),
  productFeatureConfig: (0, _product_feature_config.getCasesProductFeaturesConfig)(params)
});
exports.getCasesV3Feature = getCasesV3Feature;