"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitialFocus = useInitialFocus;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a ref for an HTML element, which will be focussed on mount.
 *
 * @example
 * ```typescript
 * const firstInput = useInitialFocus();
 *
 * <EuiFieldText inputRef={firstInput} />
 * ```
 *
 * Pass in a dependency list to focus conditionally rendered components:
 *
 * @example
 * ```typescript
 * const firstInput = useInitialFocus([showField]);
 *
 * {showField ? <input ref={firstInput} /> : undefined}
 * ```
 */
function useInitialFocus(deps = []) {
  const inputRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (inputRef.current) {
      inputRef.current.focus();
    }
  }, deps); // eslint-disable-line react-hooks/exhaustive-deps
  return inputRef;
}