"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSynonymRuleModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_delete_synonym_rule = require("../../hooks/use_delete_synonym_rule");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/synonyms_set_detail/delete_synonym_rule_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteSynonymRuleModal = ({
  closeDeleteModal,
  ruleId,
  synonymsSetId
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onSuccess = () => {
    setIsLoading(false);
    closeDeleteModal();
  };
  const onError = () => {
    setIsLoading(false);
    closeDeleteModal();
  };
  const {
    mutate: deleteEndpoint
  } = (0, _use_delete_synonym_rule.useDeleteSynonymRule)(onSuccess, onError);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const deleteOperation = () => {
    setIsLoading(true);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.rule_deleted);
    deleteEndpoint({
      synonymsSetId,
      ruleId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymRuleModal.title', {
      defaultMessage: 'Delete synonym rule'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeDeleteModal,
    onConfirm: deleteOperation,
    cancelButtonText: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymRuleModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymRuleModal.confirmButton', {
      defaultMessage: 'Delete'
    }),
    buttonColor: "danger",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymRuleModal.body', {
    defaultMessage: 'Are you sure you want to delete the synonym rule {ruleId}?',
    values: {
      ruleId
    }
  })));
};
exports.DeleteSynonymRuleModal = DeleteSynonymRuleModal;