"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticCodeExamples = exports.DenseVectorCodeExamples = exports.DefaultCodeExamples = void 0;
var _constants = require("./constants");
var _curl = require("./curl");
var _javascript = require("./javascript");
var _python = require("./python");
var _sense = require("./sense");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultCodeExamples = exports.DefaultCodeExamples = {
  exampleType: 'search',
  installTitle: _constants.INSTALL_INSTRUCTIONS_TITLE,
  installDescription: _constants.INSTALL_INSTRUCTIONS_DESCRIPTION,
  createIndexTitle: _constants.CONNECT_CREATE_DEFAULT_INDEX_CMD_TITLE,
  createIndexDescription: _constants.CONNECT_CREATE_DEFAULT_INDEX_CMD_DESCRIPTION,
  sense: _sense.ConsoleCreateIndexExamples.default,
  curl: _curl.CurlCreateIndexExamples.default,
  python: _python.PythonCreateIndexExamples.default,
  javascript: _javascript.JavascriptCreateIndexExamples.default
};
const DenseVectorCodeExamples = exports.DenseVectorCodeExamples = {
  exampleType: 'vector',
  installTitle: _constants.INSTALL_INSTRUCTIONS_TITLE,
  installDescription: _constants.INSTALL_INSTRUCTIONS_DESCRIPTION,
  createIndexTitle: _constants.CONNECT_CREATE_VECTOR_INDEX_CMD_TITLE,
  createIndexDescription: _constants.CONNECT_CREATE_VECTOR_INDEX_CMD_DESCRIPTION,
  sense: _sense.ConsoleCreateIndexExamples.dense_vector,
  curl: _curl.CurlCreateIndexExamples.dense_vector,
  python: _python.PythonCreateIndexExamples.dense_vector,
  javascript: _javascript.JavascriptCreateIndexExamples.dense_vector
};
const SemanticCodeExamples = exports.SemanticCodeExamples = {
  exampleType: 'semantic',
  installTitle: _constants.INSTALL_INSTRUCTIONS_TITLE,
  installDescription: _constants.INSTALL_INSTRUCTIONS_DESCRIPTION,
  createIndexTitle: _constants.CONNECT_CREATE_SEMANTIC_INDEX_CMD_TITLE,
  createIndexDescription: _constants.CONNECT_CREATE_SEMANTIC_INDEX_CMD_DESCRIPTION,
  sense: _sense.ConsoleCreateIndexExamples.semantic,
  curl: _curl.CurlCreateIndexExamples.semantic,
  python: _python.PythonCreateIndexExamples.semantic,
  javascript: _javascript.JavascriptCreateIndexExamples.semantic
};