"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobListUi = exports.JobList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _documentation_links = require("../../services/documentation_links");
var _job_table = require("./job_table");
var _detail_panel = require("./detail_panel");
var _components = require("../components");
var _deprecated_prompt = require("./deprecated_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_list/job_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REFRESH_RATE_MS = 30000;
class JobListUi extends _react.Component {
  static getDerivedStateFromProps(props) {
    const {
      openDetailPanel,
      history: {
        location: {
          search
        }
      }
    } = props;
    const {
      job: jobId
    } = (0, _shared_imports.extractQueryParams)(search);

    // Show deeplinked job whenever jobs get loaded or the URL changes.
    if (jobId != null) {
      openDetailPanel(jobId);
    }
    return null;
  }
  constructor(props) {
    super(props);
    props.loadJobs();
    props.kibana.services.setBreadcrumbs([_services.listBreadcrumb]);
    this.state = {};
  }
  componentDidMount() {
    this.interval = setInterval(() => this.props.refreshJobs({
      asSystemRequest: true
    }), REFRESH_RATE_MS);
  }
  componentWillUnmount() {
    clearInterval(this.interval);

    // Close the panel, otherwise it will default to already being open when we navigate back to
    // this page.
    this.props.closeDetailPanel();
  }
  renderNoPermission() {
    const title = _i18n.i18n.translate('xpack.rollupJobs.jobList.noPermissionTitle', {
      defaultMessage: 'Permission error'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": "jobListNoPermission",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 18
        }
      }, title),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobList.noPermissionText",
        defaultMessage: "You do not have permission to view or add rollup jobs.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 15
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }));
  }
  renderError(error) {
    // We can safely depend upon the shape of this error coming from http service, because we
    // handle unexpected error shapes in the API action.
    const {
      statusCode,
      error: errorString
    } = error.body;
    const title = _i18n.i18n.translate('xpack.rollupJobs.jobList.loadingErrorTitle', {
      defaultMessage: 'Error loading rollup jobs'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": "jobListError",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 18
        }
      }, title),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }, statusCode, " ", errorString),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }));
  }
  renderLoading() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobList.loadingTitle",
      defaultMessage: "Loading rollup jobs\u2026",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    })));
  }
  renderList() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "jobListPageHeader",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobListTitle",
        defaultMessage: "Rollup Jobs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 15
        }
      })),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: _documentation_links.documentationLinks.rollupJobs,
        target: "_blank",
        iconType: "question",
        "data-test-subj": "documentationLink",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.rollupJobsDocsLinkText",
        defaultMessage: "Rollup Jobs docs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 15
        }
      }))],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.DeprecationCallout, {
      linksTestSubjPrefix: "listView",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_job_table.JobTable, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_detail_panel.DetailPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }));
  }
  render() {
    const {
      isLoading,
      hasJobs,
      jobLoadError
    } = this.props;
    let content;
    if (jobLoadError) {
      if (jobLoadError.status === 403) {
        content = this.renderNoPermission();
      } else {
        content = this.renderError(jobLoadError);
      }
    } else if (!isLoading && !hasJobs) {
      content = /*#__PURE__*/_react.default.createElement(_deprecated_prompt.DeprecatedPrompt, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 17
        }
      });
    } else if (isLoading) {
      content = this.renderLoading();
    } else {
      content = this.renderList();
    }
    return content;
  }
}
exports.JobListUi = JobListUi;
(0, _defineProperty2.default)(JobListUi, "propTypes", {
  loadJobs: _propTypes.default.func,
  refreshJobs: _propTypes.default.func,
  openDetailPanel: _propTypes.default.func,
  hasJobs: _propTypes.default.bool,
  isLoading: _propTypes.default.bool
});
const JobList = exports.JobList = (0, _public.withKibana)(JobListUi);