"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepMetrics = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("../../components");
var _components2 = require("./components");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps/step_metrics.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const whiteListedMetricByFieldType = {
  numeric: {
    avg: true,
    max: true,
    min: true,
    sum: true,
    value_count: true
  },
  date: {
    max: true,
    min: true,
    value_count: true
  }
};
const checkWhiteListedMetricByFieldType = (fieldType, metricType) => {
  return !!(0, _lodash.get)(whiteListedMetricByFieldType, [fieldType, metricType]);
};

// We use an IFFE to associate metricType configs with their
// associated field types. After processing each of these
// objects should have a fieldTypes: { date: true, numeric: true }
// like object.
const metricTypesConfig = function () {
  return _constants.METRICS_CONFIG.map(config => {
    const fieldTypes = {};
    for (const [fieldType, metrics] of Object.entries(whiteListedMetricByFieldType)) {
      fieldTypes[fieldType] = !!metrics[config.type];
    }
    return {
      ...config,
      fieldTypes
    };
  });
}();
class StepMetrics extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "openMetricsPopover", () => {
      this.setState({
        metricsPopoverOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closeMetricsPopover", () => {
      this.setState({
        metricsPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onSelectField", field => {
      const {
        fields: {
          metrics
        },
        onFieldsChange
      } = this.props;
      const newMetrics = metrics.concat({
        ...field,
        types: []
      });
      onFieldsChange({
        metrics: newMetrics
      });
    });
    (0, _defineProperty2.default)(this, "onRemoveField", field => {
      const {
        fields: {
          metrics
        },
        onFieldsChange
      } = this.props;
      const newMetrics = metrics.filter(({
        name
      }) => name !== field.name);
      onFieldsChange({
        metrics: newMetrics
      });
    });
    (0, _defineProperty2.default)(this, "setMetric", (fieldName, metricType, isSelected) => {
      const {
        fields: {
          metrics
        }
      } = this.props;
      const newMetrics = [...metrics];
      const newMetric = newMetrics.find(({
        name
      }) => name === fieldName);

      // Update copied object by reference
      if (isSelected) {
        // Don't add duplicates.
        if (newMetric.types.indexOf(metricType) === -1) {
          newMetric.types.push(metricType);
        }
      } else {
        newMetric.types.splice(newMetric.types.indexOf(metricType), 1);
      }
      return newMetrics;
    });
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        fieldErrors
      } = this.props;
      const {
        metrics: errorMetrics
      } = fieldErrors;

      // Hide the error if there are no errors, which can occur if the errors are visible
      // but the user then addresses all of them.
      if (!areStepErrorsVisible || !errorMetrics) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components2.StepError, {
        title: errorMetrics,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 455,
          columnNumber: 12
        }
      });
    });
    this.state = {
      metricsPopoverOpen: false,
      listColumns: [],
      selectedMetricsMap: []
    };
  }
  renderMetricsSelectAllCheckboxes() {
    const {
      fields: {
        metrics
      },
      onFieldsChange
    } = this.props;
    let disabledCheckboxesCount = 0;

    /**
     * Look at all the metric configs and include the special "All" checkbox which adds the ability
     * to select all the checkboxes across columns and rows.
     */
    const checkboxElements = [{
      label: _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.allCheckbox', {
        defaultMessage: 'All'
      }),
      type: 'all'
    }].concat(metricTypesConfig).map(({
      label,
      type: metricType,
      fieldTypes
    }, idx) => {
      const isAllMetricTypes = metricType === 'all';
      // For this config we are either considering all user selected metrics or a subset.
      const applicableMetrics = isAllMetricTypes ? metrics : metrics.filter(({
        type
      }) => {
        return fieldTypes[type];
      });
      let checkedCount = 0;
      let isChecked = false;
      let isDisabled = false;
      if (isAllMetricTypes) {
        applicableMetrics.forEach(({
          types,
          type
        }) => {
          const whiteListedSubset = Object.keys(whiteListedMetricByFieldType[type]);
          if (whiteListedSubset.every(metricName => types.some(type => type === metricName))) {
            ++checkedCount;
          }
        });
        isDisabled = metrics.length === 0;
      } else {
        applicableMetrics.forEach(({
          types
        }) => {
          const metricSelected = types.some(type => type === metricType);
          if (metricSelected) {
            ++checkedCount;
          }
        });
        isDisabled = !metrics.some(({
          type: fieldType
        }) => checkWhiteListedMetricByFieldType(fieldType, metricType));
      }

      // Determine if a select all checkbox is checked.
      isChecked = checkedCount === applicableMetrics.length;
      if (isDisabled) ++disabledCheckboxesCount;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: `${idx}-select-all-checkbox`,
        "data-test-subj": `rollupJobMetricsSelectAllCheckbox-${metricType}`,
        disabled: isDisabled,
        label: label,
        checked: !isDisabled && isChecked,
        onChange: () => {
          if (isAllMetricTypes) {
            const newMetrics = metricTypesConfig.reduce((acc, {
              type
            }) => this.setMetrics(type, !isChecked), null);
            onFieldsChange({
              metrics: newMetrics
            });
          } else {
            onFieldsChange({
              metrics: this.setMetrics(metricType, !isChecked)
            });
          }
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 11
        }
      });
    });
    return {
      checkboxElements,
      allCheckboxesDisabled: checkboxElements.length === disabledCheckboxesCount
    };
  }
  getMetricsSelectAllMenu() {
    const {
      checkboxElements,
      allCheckboxesDisabled
    } = this.renderMetricsSelectAllCheckboxes();
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      ownFocus: true,
      isOpen: this.state.metricsPopoverOpen,
      closePopover: this.closeMetricsPopover,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: allCheckboxesDisabled,
        onClick: this.openMetricsPopover,
        "data-test-subj": "rollupJobSelectAllMetricsPopoverButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.selectAllPopoverButtonLabel', {
        defaultMessage: 'Select metrics'
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 11
      }
    }, checkboxElements.map((item, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: idx,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 15
      }
    }, item)))));
  }
  renderRowSelectAll({
    fieldName,
    fieldType,
    types
  }) {
    const {
      onFieldsChange
    } = this.props;
    const hasSelectedItems = Boolean(types.length);
    const maxItemsToBeSelected = Object.keys(whiteListedMetricByFieldType[fieldType]).length;
    const allSelected = maxItemsToBeSelected === types.length;
    const label = _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.selectAllRowLabel', {
      defaultMessage: 'All'
    });
    const onChange = () => {
      const isSelected = hasSelectedItems ? types.length !== maxItemsToBeSelected : true;
      const newMetrics = metricTypesConfig.filter(config => config.fieldTypes[fieldType]).reduce((acc, {
        type: typeConfig
      }) => {
        return this.setMetric(fieldName, typeConfig, isSelected);
      }, null);
      onFieldsChange({
        metric: newMetrics
      });
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `${fieldName}-selectAll-checkbox`,
      "data-test-subj": "rollupJobMetricsCheckbox-selectAll",
      label: label,
      checked: allSelected,
      onChange: onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 7
      }
    });
  }
  getListColumns() {
    return StepMetrics.chooserColumns.concat({
      type: 'metrics',
      name: _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.metricsColumnHeader', {
        defaultMessage: 'Metrics'
      }),
      render: ({
        name: fieldName,
        type: fieldType,
        types
      }) => {
        const {
          onFieldsChange
        } = this.props;
        const checkboxes = metricTypesConfig.map(({
          type,
          label
        }) => {
          const isAllowed = checkWhiteListedMetricByFieldType(fieldType, type);
          if (!isAllowed) {
            return;
          }
          const isSelected = types.includes(type);
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            key: `${fieldName}-${type}-checkbox`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 271,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
            id: `${fieldName}-${type}-checkbox`,
            "data-test-subj": `rollupJobMetricsCheckbox-${type}`,
            label: label,
            checked: isSelected,
            onChange: () => onFieldsChange({
              metrics: this.setMetric(fieldName, type, !isSelected)
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 272,
              columnNumber: 17
            }
          }));
        }).filter(checkbox => checkbox !== undefined);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          wrap: true,
          gutterSize: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 287,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          key: `${fieldName}-selectAll-checkbox`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 288,
            columnNumber: 13
          }
        }, this.renderRowSelectAll({
          fieldName,
          fieldType,
          types
        })), checkboxes);
      }
    });
  }
  setMetrics(metricType, isSelected) {
    const {
      fields: {
        metrics: fields
      }
    } = this.props;
    return fields.filter(field => checkWhiteListedMetricByFieldType(field.type, metricType)).reduce((acc, metric) => {
      return this.setMetric(metric.name, metricType, isSelected);
    }, []);
  }
  render() {
    const {
      fields,
      metricsFields
    } = this.props;
    const {
      metrics
    } = fields;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateMetricsTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepMetricsTitle",
      defaultMessage: "Metrics (optional)",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepMetricsDescription",
      defaultMessage: "Select the metrics to collect while rolling up data. By default, only doc_counts are collected for each group.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_components2.JobWizardStepAction, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 386,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "rollupJobCreateMetricsDocsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepMetrics.readDocsButtonLabel",
      defaultMessage: "Metrics docs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 395,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.FieldList, {
      columns: this.getListColumns(),
      fields: metrics,
      onRemoveField: this.onRemoveField,
      emptyMessage: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 410,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.emptyListLabel', {
        defaultMessage: 'No metrics fields added'
      })),
      addButton: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceEvenly",
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 417,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 418,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_components2.FieldChooser, {
        key: "stepMetricsFieldChooser",
        buttonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepMetrics.fieldsChooserLabel",
          defaultMessage: "Add metrics fields",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 422,
            columnNumber: 21
          }
        }),
        columns: StepMetrics.chooserColumns,
        fields: metricsFields,
        selectedFields: metrics,
        onSelectField: this.onSelectField,
        dataTestSubj: "rollupJobMetricsFieldChooser",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 419,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 434,
          columnNumber: 15
        }
      }, this.getMetricsSelectAllMenu())),
      dataTestSubj: "rollupJobMetricsFieldList",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 9
      }
    }), this.renderErrors());
  }
}
exports.StepMetrics = StepMetrics;
(0, _defineProperty2.default)(StepMetrics, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  metricsFields: _propTypes.default.array.isRequired
});
(0, _defineProperty2.default)(StepMetrics, "chooserColumns", [{
  field: 'name',
  name: _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.fieldColumnLabel', {
    defaultMessage: 'Field'
  }),
  sortable: true,
  width: '240px'
}, {
  field: 'type',
  name: _i18n.i18n.translate('xpack.rollupJobs.create.stepMetrics.typeColumnLabel', {
    defaultMessage: 'Type'
  }),
  truncateText: true,
  sortable: true,
  width: '100px'
}]);