"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Main = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _full_body_height_css = require("@kbn/css-utils/public/full_body_height_css");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _format = require("../lib/format");
var _constants = require("../constants");
var _types = require("../types");
var _hooks = require("../hooks");
var _context = require("../context");
var _output_pane = require("./output_pane");
var _main_controls = require("./main_controls");
var _editor = require("./editor");
var _request_flyout = require("./request_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/painless_lab/public/application/components/main.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mainStyles = {
  container: (0, _react2.css)({
    // The panel's container should adopt the height of the main container
    height: '100%'
  }),
  leftPane: ({
    euiTheme
  }) => (0, _react2.css)({
    paddingTop: euiTheme.size.m,
    backgroundColor: euiTheme.colors.emptyShade
  }),
  mainContainer: ({
    euiTheme
  }) => {
    /**
     * This is a very brittle way of preventing the editor and other content from disappearing
     * behind the bottom bar.
     */
    const bottomBarHeight = `(${euiTheme.size.base} * 3)`;

    // adding dev tool top bar + bottom bar height to the body offset
    // (they're both the same height, hence the x2)
    const bodyOffset = `(${bottomBarHeight} * 2)`;
    return (0, _full_body_height_css.kbnFullBodyHeightCss)(bodyOffset);
  }
};
const Main = () => {
  const {
    store: {
      payload,
      validation
    },
    updatePayload,
    services: {
      http
    },
    links
  } = (0, _context.useAppContext)();
  const styles = (0, _use_memo_css.useMemoCss)(mainStyles);
  const [isRequestFlyoutOpen, setRequestFlyoutOpen] = (0, _react.useState)(false);
  const {
    inProgress,
    response,
    submit
  } = (0, _hooks.useSubmitCode)(http);

  // Live-update the output and persist payload state as the user changes it.
  (0, _react.useEffect)(() => {
    if (validation.isValid) {
      submit(payload);
    }
  }, [payload, submit, validation.isValid]);
  const toggleRequestFlyout = () => {
    setRequestFlyoutOpen(!isRequestFlyoutOpen);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.mainContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.leftPane,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "euiScreenReaderOnly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.painlessLab.title', {
    defaultMessage: 'Painless Lab'
  }))), /*#__PURE__*/_react.default.createElement(_editor.Editor, {
    context: payload.context,
    code: payload.code,
    onChange: nextCode => updatePayload({
      code: nextCode
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_output_pane.OutputPane, {
    isLoading: inProgress,
    response: response,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_main_controls.MainControls, {
    links: links,
    isLoading: inProgress,
    toggleRequestFlyout: toggleRequestFlyout,
    isRequestFlyoutOpen: isRequestFlyoutOpen,
    reset: () => updatePayload({
      code: _constants.exampleScript
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), isRequestFlyoutOpen && /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
    links: links,
    onClose: () => setRequestFlyoutOpen(false),
    requestBody: (0, _format.formatRequestPayload)(payload, _types.PayloadFormat.PRETTY),
    response: response ? (0, _format.formatJson)(response.result || response.error) : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }));
};
exports.Main = Main;