"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAgentCard = createAgentCard;
var _onechatCommon = require("@kbn/onechat-common");
var _a2a = require("../../routes/a2a");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createAgentCard({
  agent,
  baseUrl,
  toolsService,
  request
}) {
  const registry = await toolsService.getRegistry({
    request
  });
  const availableTools = await registry.list({});
  const selectedTools = (0, _onechatCommon.filterToolsBySelection)(availableTools, agent.configuration.tools);
  const skills = selectedTools.map(tool => ({
    id: tool.id,
    name: tool.id,
    description: tool.description,
    tags: ['tool'],
    examples: [],
    inputModes: ['text/plain', 'application/json'],
    outputModes: ['text/plain', 'application/json']
  }));
  return {
    name: agent.name,
    description: agent.description,
    url: `${baseUrl}${_a2a.A2A_SERVER_PATH}/${agent.id}`,
    provider: {
      organization: 'Elastic',
      url: 'https://elastic.co'
    },
    version: '0.1.0',
    protocolVersion: '0.3.0',
    capabilities: {
      streaming: false,
      pushNotifications: false,
      stateTransitionHistory: false
    },
    securitySchemes: {
      authorization: {
        type: 'apiKey',
        name: 'Authorization',
        in: 'header',
        description: 'Authentication token'
      }
    },
    defaultInputModes: ['text/plain'],
    defaultOutputModes: ['text/plain'],
    skills,
    supportsAuthenticatedExtendedCard: false
  };
}