"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUISettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUISettings = ({
  uiSettings
}) => {
  uiSettings.register({
    [_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.onechat.uiSettings.feature.description', {
        defaultMessage: 'Enables Elastic Agent Builder.'
      }),
      name: _i18n.i18n.translate('xpack.onechat.uiSettings.feature.name', {
        defaultMessage: 'Elastic Agent Builder'
      }),
      schema: _configSchema.schema.boolean(),
      value: true,
      technicalPreview: true,
      requiresPageReload: true,
      readonly: false
    },
    [_managementSettingsIds.AGENT_BUILDER_DASHBOARD_TOOLS_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.onechat.uiSettings.createVisualizations.description', {
        defaultMessage: 'Enables the Dashboard Agent and related tools for Elastic Agent Builder.'
      }),
      name: _i18n.i18n.translate('xpack.onechat.uiSettings.createVisualizations.name', {
        defaultMessage: 'Elastic Agent Builder: Dashboard Agent and tools'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      technicalPreview: true,
      requiresPageReload: true,
      readonly: true,
      readonlyMode: 'ui'
    },
    [_managementSettingsIds.AGENT_BUILDER_NAV_ENABLED_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.onechat.uiSettings.nav.description', {
        defaultMessage: 'Enables the Elastic Agent Builder icon in the global navigation bar.'
      }),
      name: _i18n.i18n.translate('xpack.onechat.uiSettings.nav.name', {
        defaultMessage: 'Elastic Agent Builder Navigation Icon'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      technicalPreview: true,
      requiresPageReload: true,
      readonly: true,
      readonlyMode: 'ui'
    }
  });
};
exports.registerUISettings = registerUISettings;