"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveServices = void 0;
var _telemetry = require("../../../telemetry");
var _resolve_selected_connector_id = require("./resolve_selected_connector_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolveServices = async ({
  agentId,
  connectorId,
  request,
  logger,
  inference,
  conversationService,
  agentService,
  uiSettings,
  savedObjects
}) => {
  const selectedConnectorId = await (0, _resolve_selected_connector_id.resolveSelectedConnectorId)({
    request,
    connectorId,
    uiSettings,
    savedObjects,
    inference
  });
  if (!selectedConnectorId) {
    throw new Error('No connector available for chat execution');
  }
  const hasAgent = await agentService.getRegistry({
    request
  }).then(agentRegistry => agentRegistry.has(agentId));
  if (!hasAgent) {
    throw new Error(`Agent "${agentId}" not found or not available`);
  }
  const [conversationClient, chatModel] = await Promise.all([conversationService.getScopedClient({
    request
  }), inference.getChatModel({
    request,
    connectorId: selectedConnectorId,
    chatModelOptions: {
      telemetryMetadata: _telemetry.MODEL_TELEMETRY_METADATA
    }
  })]);
  return {
    conversationClient,
    chatModel,
    selectedConnectorId
  };
};
exports.resolveServices = resolveServices;