"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ToolsService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }

  // public APIs

  async list() {
    const {
      results
    } = await this.http.get(`${_constants.publicApiPath}/tools`, {});
    return results;
  }
  async get({
    toolId
  }) {
    return await this.http.get(`${_constants.publicApiPath}/tools/${toolId}`, {});
  }
  async delete({
    toolId
  }) {
    return await this.http.delete(`${_constants.publicApiPath}/tools/${toolId}`, {});
  }
  async create(tool) {
    return await this.http.post(`${_constants.publicApiPath}/tools`, {
      body: JSON.stringify(tool)
    });
  }
  async update(id, update) {
    return await this.http.put(`${_constants.publicApiPath}/tools/${id}`, {
      body: JSON.stringify(update)
    });
  }
  async execute({
    toolId,
    toolParams,
    connectorId
  }) {
    return await this.http.post(`${_constants.publicApiPath}/tools/_execute`, {
      body: JSON.stringify({
        tool_id: toolId,
        tool_params: toolParams,
        connector_id: connectorId
      })
    });
  }

  // internal APIs

  async bulkDelete(toolsIds) {
    return await this.http.post(`${_constants.internalApiPath}/tools/_bulk_delete`, {
      body: JSON.stringify({
        ids: toolsIds
      })
    });
  }
  async resolveSearchSources({
    pattern
  }) {
    return await this.http.get(`${_constants.internalApiPath}/tools/_resolve_search_sources`, {
      query: {
        pattern
      }
    });
  }
  async getWorkflow(workflowId) {
    return await this.http.get(`${_constants.internalApiPath}/tools/_get_workflow/${workflowId}`);
  }
  async listWorkflows({
    page,
    limit
  }) {
    return await this.http.get(`${_constants.internalApiPath}/tools/_list_workflows`, {
      query: {
        page,
        limit
      }
    });
  }
  async getToolTypes() {
    const response = await this.http.get(`${_constants.internalApiPath}/tools/_types_info`);
    return response.toolTypes;
  }
}
exports.ToolsService = ToolsService;