"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nMessages = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nMessages = exports.i18nMessages = {
  paramUnusedWarning: name => _i18n.i18n.translate('xpack.onechat.tools.newTool.paramUnusedWarning', {
    defaultMessage: 'Parameter "{name}" is not used in the ES|QL query.',
    values: {
      name
    }
  }),
  paramNameLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramNameLabel', {
    defaultMessage: 'Name'
  }),
  paramNamePlaceholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramNamePlaceholder', {
    defaultMessage: 'Name'
  }),
  paramDescriptionLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramDescriptionLabel', {
    defaultMessage: 'Description'
  }),
  paramDescriptionPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramDescriptionPlaceholder', {
    defaultMessage: 'Description'
  }),
  paramTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.paramTypeLabel', {
    defaultMessage: 'Type'
  }),
  optionalParamLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.optionalParamLabel', {
    defaultMessage: 'Optional'
  }),
  removeParamButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.removeParamButtonLabel', {
    defaultMessage: 'Remove parameter'
  }),
  addParamButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.addParamButtonLabel', {
    defaultMessage: 'Add a parameter'
  }),
  inferParamsButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.inferParamsButtonLabel', {
    defaultMessage: 'Infer parameters'
  }),
  noParamsMessage: _i18n.i18n.translate('xpack.onechat.tools.newTool.noParamsMessage', {
    defaultMessage: 'Add parameters or infer them from your ES|QL query.'
  }),
  optionalFieldLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.optionalFieldLabel', {
    defaultMessage: 'Optional'
  }),
  documentationLinkLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.documentationLinkLabel', {
    defaultMessage: 'Documentation'
  }),
  systemReferences: {
    documentation: {
      title: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.title', {
        defaultMessage: 'System references'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.description', {
        defaultMessage: 'These values are used by agents and configurations, not shown to end users.'
      }),
      fieldsHelp: {
        title: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.fieldsHelp.title', {
          defaultMessage: 'What are these fields?'
        }),
        toolId: {
          label: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.fieldsHelp.toolId.label', {
            defaultMessage: 'Tool ID'
          }),
          description: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.fieldsHelp.toolId.description', {
            defaultMessage: 'Unique ID for referencing the tool in code or configurations.'
          })
        },
        description: {
          label: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.fieldsHelp.description.label', {
            defaultMessage: 'Description'
          }),
          description: _i18n.i18n.translate('xpack.onechat.tools.newTool.systemReferences.fieldsHelp.description.description', {
            defaultMessage: 'Help humans and agents understand how the tool works. Start with a short human-friendly summary, because the first ~50 characters appear in the tool list.'
          })
        }
      },
      toolBasicsDocumentationLink: _i18n.i18n.translate('xpack.onechat.tools.newTool.toolBasics.documentationLink', {
        defaultMessage: 'Tool basics'
      })
    },
    form: {
      toolId: {
        label: _i18n.i18n.translate('xpack.onechat.tools.newTool.form.toolIdLabel', {
          defaultMessage: 'Tool ID'
        }),
        helpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.form.toolIdHelpText', {
          defaultMessage: 'Tool ID must start and end with a letter or number, and can only contain lowercase letters, numbers, dots, and underscores.'
        })
      },
      description: {
        label: _i18n.i18n.translate('xpack.onechat.tools.newTool.form.descriptionLabel', {
          defaultMessage: 'Description'
        })
      }
    }
  },
  toolLabels: {
    documentation: {
      title: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.title', {
        defaultMessage: 'Labels'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.description', {
        defaultMessage: "Labels help with filtering, search, and bulk selection — they don't affect how tools behave."
      }),
      documentationLink: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.toolLabelsDocumentationLink', {
        defaultMessage: 'Tool labels'
      })
    },
    form: {
      label: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.formLabel', {
        defaultMessage: 'Labels'
      }),
      placeholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.labels.formPlaceholder', {
        defaultMessage: 'Add or create labels'
      })
    }
  },
  configuration: {
    documentation: {
      title: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.title', {
        defaultMessage: 'Configuration'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.description', {
        defaultMessage: 'Set up how the tool works, by defining the index pattern or ES|QL query syntax and any required parameters.'
      }),
      documentationLink: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.documentationLink', {
        defaultMessage: 'Configuring a tool'
      })
    },
    form: {
      type: {
        label: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.label', {
          defaultMessage: 'Type'
        }),
        esqlOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.esqlOption', {
          defaultMessage: 'ES|QL'
        }),
        indexSearchOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.indexSearchOption', {
          defaultMessage: 'Index search'
        }),
        workflowOption: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.type.workflowOption', {
          defaultMessage: 'Workflow'
        })
      },
      indexSearch: {
        patternLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.patternLabel', {
          defaultMessage: 'Target pattern'
        }),
        defaultRowLimitLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.defaultRowLimitLabel', {
          defaultMessage: 'Row limit'
        }),
        defaultRowLimitHelpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.defaultRowLimitHelpText', {
          defaultMessage: 'Maximum number of rows to return from ES|QL queries.'
        }),
        customInstructionsLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.customInstructionsLabel', {
          defaultMessage: 'Custom instructions'
        }),
        customInstructionsHelpText: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.customInstructionsHelpText', {
          defaultMessage: 'Additional guidance for ES|QL query generation, such as field selection or limit logic.'
        }),
        customInstructionsPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.indexSearch.customInstructionsPlaceholder', {
          defaultMessage: 'e.g., "Always include timestamp field" '
        })
      },
      esql: {
        queryLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.esql.queryLabel', {
          defaultMessage: 'ES|QL Query'
        }),
        parametersLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.esql.parametersLabel', {
          defaultMessage: 'ES|QL Parameters'
        })
      },
      workflow: {
        workflowLabel: _i18n.i18n.translate('xpack.onechat.tools.newTool.configuration.form.workflow.workflowLabel', {
          defaultMessage: 'Workflow'
        })
      }
    }
  }
};