"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenameConversationModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _use_conversation_id = require("../../../context/conversation/use_conversation_id");
var _use_conversation = require("../../../hooks/use_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/rename_conversation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RenameConversationModal = ({
  isOpen,
  onClose
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newTitle, setNewTitle] = (0, _react.useState)('');
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    title
  } = (0, _use_conversation.useConversationTitle)();
  const {
    conversationActions
  } = (0, _conversation_context.useConversationContext)();
  const renameModalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'renameConversationModal'
  });

  // Reset newTitle when title changes or modal opens
  (0, _react.useEffect)(() => {
    if (title) {
      setNewTitle(title);
    }
  }, [title, isOpen]);
  const handleRename = (0, _react.useCallback)(async () => {
    if (!conversationId || !newTitle.trim()) {
      return;
    }
    setIsLoading(true);
    await conversationActions.renameConversation(conversationId, newTitle.trim());
    setIsLoading(false);
    onClose();
  }, [conversationId, newTitle, conversationActions, onClose]);
  const handleCancel = (0, _react.useCallback)(() => {
    setNewTitle(title || '');
    onClose();
  }, [title, onClose]);
  if (!isOpen || !conversationId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": renameModalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.renameConversationModal.title",
      defaultMessage: "Rename conversation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }),
    titleProps: {
      id: renameModalTitleId
    },
    onCancel: handleCancel,
    onConfirm: handleRename,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.renameConversationModal.cancelButton",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.renameConversationModal.confirmButton",
      defaultMessage: "Rename",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }),
    defaultFocusedButton: "confirm",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: newTitle,
    onChange: e => setNewTitle(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.onechat.conversationTitle.renameConversationModal.inputPlaceholder', {
      defaultMessage: 'Enter conversation name'
    }),
    fullWidth: true,
    autoFocus: true,
    "data-test-subj": "renameConversationInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
};
exports.RenameConversationModal = RenameConversationModal;