"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAgent = void 0;
var _react = _interopRequireDefault(require("react"));
var _agent_form = require("./agent_form");
var _delete_agent_context = require("../../../context/delete_agent_context");
var _app_paths = require("../../../utils/app_paths");
var _use_navigation = require("../../../hooks/use_navigation");
var _use_agent_by_id = require("../../../hooks/agents/use_agent_by_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/edit_agent.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditAgentForm = ({
  agentId
}) => {
  const {
    deleteAgent
  } = (0, _delete_agent_context.useDeleteAgent)();
  const {
    agent
  } = (0, _use_agent_by_id.useOnechatAgentById)(agentId);
  return /*#__PURE__*/_react.default.createElement(_agent_form.AgentForm, {
    editingAgentId: agentId,
    onDelete: () => {
      if (agent) {
        deleteAgent({
          agent
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
};
const EditAgent = ({
  agentId
}) => {
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  return /*#__PURE__*/_react.default.createElement(_delete_agent_context.DeleteAgentProvider, {
    onSuccess: () => {
      navigateToOnechatUrl(_app_paths.appPaths.agents.list);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EditAgentForm, {
    agentId: agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
exports.EditAgent = EditAgent;