"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsStatusRuleData = void 0;
exports.syntheticsMonitorStatusAlertParamsToKqlQuery = syntheticsMonitorStatusAlertParamsToKqlQuery;
var _esQuery = require("@kbn/es-query");
var _synthetics_common = require("./synthetics_common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * @param params from a Synthetics Monitor Status Alert
 * @returns KQL query string
 */
function syntheticsMonitorStatusAlertParamsToKqlQuery(params) {
  const {
    condition,
    kqlQuery,
    ...rest
  } = params;
  const filters = (0, _synthetics_common.mapExtraSyntheticsFilters)(rest, kqlQuery);
  filters.push(_esQuery.nodeBuilder.is('monitor.status', 'down'));
  return (0, _esQuery.toKqlExpression)(_esQuery.nodeBuilder.and(filters));
}
const getSyntheticsStatusRuleData = ({
  rule
}) => {
  const params = rule.params;
  const query = syntheticsMonitorStatusAlertParamsToKqlQuery(params);
  return {
    discoverAppLocatorParams: {
      query: {
        language: 'kuery',
        query
      },
      dataViewSpec: _synthetics_common.SYNTHETICS_TEMP_DATA_VIEW
    }
  };
};
exports.getSyntheticsStatusRuleData = getSyntheticsStatusRuleData;