"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddSuggestedDashboards = void 0;
var _react = require("react");
var _hooks = require("@kbn/response-ops-rule-form/src/common/hooks");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddSuggestedDashboards = ({
  rule,
  onSuccessAddSuggestedDashboard
}) => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _public.useKibana)();
  const [addingDashboardId, setAddingDashboardId] = (0, _react.useState)();
  const onError = (0, _react.useCallback)(error => {
    setAddingDashboardId(undefined);
    notifications.toasts.addError(error, {
      title: _i18n.i18n.translate('xpack.observability.alertDetails.addSuggestedDashboardError', {
        defaultMessage: 'Error adding suggested dashboard'
      })
    });
  }, [notifications.toasts]);
  const onSuccess = (0, _react.useCallback)(async () => {
    if (!addingDashboardId) throw new Error('Adding dashboard id not defined, this should never occur');
    await onSuccessAddSuggestedDashboard();
    setAddingDashboardId(undefined);
    notifications.toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.observability.alertDetails.addSuggestedDashboardSuccess.title', {
        defaultMessage: 'Added to linked dashboard'
      }),
      text: _i18n.i18n.translate('xpack.observability.alertDetails.addSuggestedDashboardSuccess.text', {
        defaultMessage: 'From now on, this dashboard will be linked to all alerts triggered by this rule'
      })
    });
  }, [addingDashboardId, notifications.toasts, onSuccessAddSuggestedDashboard]);
  const {
    mutateAsync: updateRule
  } = (0, _hooks.useUpdateRule)({
    http,
    onError,
    onSuccess
  });
  const onClickAddSuggestedDashboard = (0, _react.useCallback)(d => {
    var _rule$artifacts;
    const updatedRule = {
      ...rule,
      artifacts: {
        ...(rule.artifacts || {}),
        dashboards: [...(((_rule$artifacts = rule.artifacts) === null || _rule$artifacts === void 0 ? void 0 : _rule$artifacts.dashboards) || []), {
          id: d.id
        }]
      }
    };
    updateRule({
      id: rule.id,
      formData: updatedRule
    });
    setAddingDashboardId(d.id);
  }, [rule, updateRule]);
  return {
    onClickAddSuggestedDashboard,
    addingDashboardId
  };
};
exports.useAddSuggestedDashboards = useAddSuggestedDashboards;