"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_INSTRUCTIONS_HEADER = void 0;
exports.getSystemMessageFromInstructions = getSystemMessageFromInstructions;
var _lodash = require("lodash");
var _with_token_budget = require("../../../common/utils/with_token_budget");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_INSTRUCTIONS_HEADER = exports.USER_INSTRUCTIONS_HEADER = `## User instructions
          
What follows is a set of instructions provided by the user, please abide by them
as long as they don't conflict with anything you've been told so far:

`;
function getSystemMessageFromInstructions({
  // application instructions registered by the functions. These will be displayed first
  applicationInstructions,
  // instructions provided by the user via the KB. These will be displayed after the application instructions and only if they fit within the token budget
  kbUserInstructions,
  // instructions provided by the user via the API. These will be displayed after the application instructions and only if they fit within the token budget
  apiUserInstructions,
  availableFunctionNames
}) {
  const allApplicationInstructions = (0, _lodash.compact)(applicationInstructions.flatMap(instruction => {
    if (typeof instruction === 'function') {
      return instruction({
        availableFunctionNames
      });
    }
    return instruction;
  }));

  // all api user instructions and KB instructions.
  // api instructions will be prioritized over Knowledge Base instructions if the id is the same
  const allUserInstructions = (0, _with_token_budget.withTokenBudget)((0, _lodash.uniqBy)([...apiUserInstructions, ...kbUserInstructions], i => i.id), 1000);
  return [
  // application instructions
  ...allApplicationInstructions,
  // user instructions
  ...(allUserInstructions.length ? [USER_INSTRUCTIONS_HEADER, ...allUserInstructions] : [])].map(instruction => {
    return typeof instruction === 'string' ? instruction : instruction.text;
  }).join('\n\n');
}