"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateObj = void 0;
Object.defineProperty(exports, "validateVersion", {
  enumerable: true,
  get: function () {
    return _objectVersioningUtils.validateVersion;
  }
});
var _objectVersioningUtils = require("@kbn/object-versioning-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Validate an object based on a schema.
 *
 * @param obj The object to validate
 * @param objSchema The schema to validate the object against
 * @returns null or ValidationError
 */
const validateObj = (obj, objSchema) => {
  if (objSchema === undefined) {
    return null;
  }
  try {
    objSchema.validate(obj);
    return null;
  } catch (e) {
    return e;
  }
};
exports.validateObj = validateObj;