"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_track_metric = require("../../application/hooks/use_track_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/page_loading/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PageLoadingUI() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    style: {
      height: 'calc(100vh - 50px)'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 17
      }
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.pageLoadingTitle",
      defaultMessage: "Loading\u2026",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 9
    }
  })));
}
const PageLoadingTracking = ({
  pageViewTitle
}) => {
  const path = pageViewTitle.toLowerCase().replace(/-/g, '').replace(/\s+/g, '_');
  (0, _use_track_metric.useTrackPageview)({
    path
  });
  (0, _use_track_metric.useTrackPageview)({
    path,
    delay: 15000
  });
  return /*#__PURE__*/_react.default.createElement(PageLoadingUI, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  });
};
const PageLoading = ({
  pageViewTitle
}) => {
  if (pageViewTitle) {
    return /*#__PURE__*/_react.default.createElement(PageLoadingTracking, {
      pageViewTitle: pageViewTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(PageLoadingUI, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 10
    }
  });
};
exports.PageLoading = PageLoading;