"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityControl = exports.EMPTY_FIELD_VALUE_LABEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _entity_config = require("./entity_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/entity_control/entity_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Configuration for entity field dropdown options
 */

const EMPTY_FIELD_VALUE_LABEL = exports.EMPTY_FIELD_VALUE_LABEL = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.emptyPartitionFieldLabel.', {
  defaultMessage: '"" (empty string)'
});
class EntityControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "inputRef", void 0);
    (0, _defineProperty2.default)(this, "state", {
      selectedOptions: undefined,
      options: undefined,
      isLoading: false,
      isEntityConfigPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onChange", selectedOptions => {
      var _options$0$value, _options$0$value$valu, _options$0$value2;
      const options = selectedOptions.length > 0 ? selectedOptions : undefined;
      this.setState({
        selectedOptions: options
      });
      const fieldValue = Array.isArray(options) && ((_options$0$value = options[0].value) === null || _options$0$value === void 0 ? void 0 : _options$0$value.value) !== null ? (_options$0$value$valu = (_options$0$value2 = options[0].value) === null || _options$0$value2 === void 0 ? void 0 : _options$0$value2.value) !== null && _options$0$value$valu !== void 0 ? _options$0$value$valu : null : null;
      this.props.entityFieldValueChanged(this.props.entity, fieldValue);
    });
    (0, _defineProperty2.default)(this, "onManualInput", inputValue => {
      const normalizedSearchValue = inputValue.trim().toLowerCase();
      if (!normalizedSearchValue) {
        return;
      }
      const manualInputValue = {
        label: inputValue,
        value: {
          value: inputValue
        }
      };
      this.setState({
        selectedOptions: [manualInputValue]
      });
      this.props.entityFieldValueChanged(this.props.entity, inputValue);
    });
    (0, _defineProperty2.default)(this, "onSearchChange", searchValue => {
      this.setState({
        isLoading: true,
        options: []
      });
      this.props.onSearchChange(this.props.entity, searchValue);
    });
    (0, _defineProperty2.default)(this, "renderOption", (option, searchValue) => {
      var _option$value;
      const highlightedLabel = /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
        search: searchValue,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 30
        }
      }, option.label);
      return (_option$value = option.value) !== null && _option$value !== void 0 && _option$value.maxRecordScore ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(option.value.maxRecordScore, this.props.euiTheme),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 7
        }
      }, highlightedLabel) : highlightedLabel;
    });
  }
  componentDidUpdate(prevProps) {
    const {
      entity,
      forceSelection,
      isLoading,
      options: propOptions
    } = this.props;
    const {
      options: stateOptions,
      selectedOptions
    } = this.state;
    const {
      fieldValue
    } = entity;
    let selectedOptionsUpdate = selectedOptions;
    if (selectedOptions === undefined && fieldValue !== null || Array.isArray(selectedOptions) &&
    // @ts-ignore
    selectedOptions[0].value !== fieldValue && fieldValue !== null) {
      selectedOptionsUpdate = [{
        label: fieldValue === '' ? EMPTY_FIELD_VALUE_LABEL : fieldValue,
        value: fieldValue
      }];
    } else if (Array.isArray(selectedOptions) && fieldValue === null) {
      selectedOptionsUpdate = undefined;
    }
    if (prevProps.isLoading === true && isLoading === false) {
      this.setState({
        isLoading: false,
        selectedOptions: selectedOptionsUpdate
      });
    }
    if (!(0, _lodash.isEqual)(propOptions, stateOptions)) {
      this.setState({
        options: propOptions
      });
    }
    if (forceSelection && this.inputRef) {
      this.inputRef.focus();
    }
  }
  render() {
    const {
      entity,
      forceSelection,
      isModelPlotEnabled,
      config,
      onConfigChange
    } = this.props;
    const {
      isLoading,
      options,
      selectedOptions
    } = this.state;
    const control = /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "aria-label": _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.entityControlLabel', {
        defaultMessage: 'Entity control'
      }),
      async: true,
      isLoading: isLoading,
      inputRef: input => {
        if (input) {
          this.inputRef = input;
        }
      },
      style: {
        minWidth: '300px'
      },
      placeholder: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.enterValuePlaceholder', {
        defaultMessage: 'Enter value'
      }),
      singleSelection: {
        asPlainText: true
      },
      onCreateOption: this.onManualInput,
      customOptionText: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.setManualInputHelperText', {
        defaultMessage: 'No matching values'
      }),
      options: options,
      selectedOptions: selectedOptions,
      onChange: this.onChange,
      onSearchChange: this.onSearchChange,
      isClearable: true,
      renderOption: this.renderOption,
      "data-test-subj": `mlSingleMetricViewerEntitySelection ${entity.fieldName}`,
      prepend: /*#__PURE__*/_react.default.createElement(_entity_config.EntityConfig, {
        entity: entity,
        isModelPlotEnabled: isModelPlotEnabled,
        config: config,
        onConfigChange: onConfigChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 11
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    });
    const selectMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.selectFieldMessage",
      defaultMessage: "Select {fieldName}",
      values: {
        fieldName: entity.fieldName
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: entity.fieldName,
      helpText: forceSelection ? selectMessage : null,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 9
      }
    }, control));
  }
}
exports.EntityControl = EntityControl;