"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDescriptionPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/filter_lists/components/edit_description_popover/edit_description_popover.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React popover for editing the description of a filter list.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class EditDescriptionPopover extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onChange", e => {
      this.setState({
        value: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      if (this.state.isPopoverOpen === false) {
        this.setState({
          isPopoverOpen: !this.state.isPopoverOpen,
          value: this.props.description
        });
      } else {
        this.closePopover();
      }
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      if (this.state.isPopoverOpen === true) {
        this.setState({
          isPopoverOpen: false
        });
        this.props.updateDescription(this.state.value);
      }
    });
    this.state = {
      isPopoverOpen: false,
      value: props.description
    };
  }
  render() {
    const {
      isPopoverOpen,
      value
    } = this.state;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "primary",
      onClick: this.onButtonClick,
      iconType: "pencil",
      "aria-label": _i18n.i18n.translate('xpack.ml.settings.filterLists.editDescriptionPopover.editDescriptionAriaLabel', {
        defaultMessage: 'Edit description'
      }),
      isDisabled: this.props.canCreateFilter === false,
      "data-test-subj": "mlFilterListEditDescriptionButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "filter_list_description_popover",
      ownFocus: true,
      button: button,
      isOpen: isPopoverOpen,
      closePopover: this.closePopover,
      initialFocus: "#filter_list_edit_description_row",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '300px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "filter_list_edit_description_row",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.editDescriptionPopover.filterListDescriptionAriaLabel",
        defaultMessage: "Filter list description",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "filter_list_description",
      value: value,
      onChange: this.onChange,
      "data-test-subj": 'mlFilterListDescriptionInput',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 17
      }
    }))))));
  }
}
exports.EditDescriptionPopover = EditDescriptionPopover;
(0, _defineProperty2.default)(EditDescriptionPopover, "displayName", 'EditDescriptionPopover');
(0, _defineProperty2.default)(EditDescriptionPopover, "propTypes", {
  description: _propTypes.default.string,
  updateDescription: _propTypes.default.func.isRequired,
  canCreateFilter: _propTypes.default.bool.isRequired
});