"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectsApiProvider = void 0;
exports.useSavedObjectsApiService = useSavedObjectsApiService;
var _react = require("react");
var _app = require("../../../../common/constants/app");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Service for managing job saved objects

const savedObjectsApiProvider = httpService => ({
  jobsSpaces() {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/jobs_spaces`,
      method: 'GET',
      version: '1'
    });
  },
  updateJobsSpaces(jobType, jobIds, spacesToAdd, spacesToRemove) {
    const body = JSON.stringify({
      jobType,
      jobIds,
      spacesToAdd,
      spacesToRemove
    });
    return httpService.http({
      path: `${_app.ML_EXTERNAL_BASE_PATH}/saved_objects/update_jobs_spaces`,
      method: 'POST',
      body,
      version: '2023-10-31'
    });
  },
  removeItemFromCurrentSpace(mlSavedObjectType, ids) {
    const body = JSON.stringify({
      mlSavedObjectType,
      ids
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/remove_item_from_current_space`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  syncSavedObjects(simulate = false, addToAllSpaces) {
    return httpService.http({
      path: `${_app.ML_EXTERNAL_BASE_PATH}/saved_objects/sync`,
      method: 'GET',
      query: {
        simulate,
        addToAllSpaces
      },
      version: '2023-10-31'
    });
  },
  initSavedObjects(simulate = false) {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/initialize`,
      method: 'GET',
      query: {
        simulate
      },
      version: '1'
    });
  },
  syncCheck(mlSavedObjectType) {
    const body = JSON.stringify({
      mlSavedObjectType
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/sync_check`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  canDeleteMLSpaceAwareItems(mlSavedObjectType, ids) {
    const body = JSON.stringify({
      ids
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/can_delete_ml_space_aware_item/${mlSavedObjectType}`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  canSyncToAllSpaces(mlSavedObjectType) {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/can_sync_to_all_spaces${mlSavedObjectType !== undefined ? `/${mlSavedObjectType}` : ''}`,
      method: 'GET',
      version: '1'
    });
  },
  trainedModelsSpaces() {
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/saved_objects/trained_models_spaces`,
      method: 'GET',
      version: '1'
    });
  },
  updateModelsSpaces(modelIds, spacesToAdd, spacesToRemove) {
    const body = JSON.stringify({
      modelIds,
      spacesToAdd,
      spacesToRemove
    });
    return httpService.http({
      path: `${_app.ML_EXTERNAL_BASE_PATH}/saved_objects/update_trained_models_spaces`,
      method: 'POST',
      body,
      version: '2023-10-31'
    });
  }
});
exports.savedObjectsApiProvider = savedObjectsApiProvider;
/**
 * Hooks for accessing {@link SavedObjectsApiService} in React components.
 */
function useSavedObjectsApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => savedObjectsApiProvider(httpService), [httpService]);
}