"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _overview_ml_page = require("./overview_ml_page");
var _locator = require("../../locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/data_visualizer_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataVisualizerGrid = ({
  buttonType,
  isEsqlEnabled
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  gutterSize: "m",
  columns: 2,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, isEsqlEnabled ? /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: _locator.ML_PAGES.DATA_VISUALIZER_ESQL,
  title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.selectESQLTitle",
    defaultMessage: "ES|QL",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    "aria-label": _i18n.i18n.translate('xpack.ml.datavisualizer.selector.technicalPreviewBetaBadgeLabel', {
      defaultMessage: 'Technical Preview'
    }),
    iconType: "beaker",
    size: "m",
    color: "hollow",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.esqlTechnicalPreviewBadge.titleMsg",
      defaultMessage: "ES|QL data visualizer is in technical preview.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 19
      }
    }),
    tooltipPosition: 'right',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 15
    }
  }))),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.technicalPreviewBadge.contentMsg', {
    defaultMessage: 'The Elasticsearch Query Language (ES|QL) provides a powerful way to filter, transform, and analyze data stored in Elasticsearch.'
  }),
  iconType: "esqlVis",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.tryESQLNowButtonLabel', {
    defaultMessage: 'Try it now!'
  }),
  cardDataTestSubj: "mlDataVisualizerSelectESQLCard",
  buttonDataTestSubj: "mlDataVisualizerSelectESQLButton",
  buttonType: buttonType,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 7
  }
}) : null, /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: "/filedatavisualizer",
  title: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.importDataTitle', {
    defaultMessage: 'Visualize data from a file'
  }),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.importDataDescription', {
    defaultMessage: 'Upload your file, analyze its data, and optionally import the data into an index.'
  }),
  iconType: "addDataApp",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.uploadFileButtonLabel', {
    defaultMessage: 'Select file'
  }),
  cardDataTestSubj: "mlDataVisualizerCardImportData",
  buttonDataTestSubj: "mlDataVisualizerUploadFileButton",
  buttonType: buttonType,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: "/datavisualizer_index_select",
  title: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewTitle', {
    defaultMessage: 'Visualize data from a data view'
  }),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewTitle', {
    defaultMessage: 'Analyze data, its shape, and statistical metadata from a data view.'
  }),
  iconType: "dataVisualizer",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewButtonLabel', {
    defaultMessage: 'Select data view'
  }),
  cardDataTestSubj: "mlDataVisualizerCardIndexData",
  buttonDataTestSubj: "mlDataVisualizerSelectIndexButton",
  buttonType: buttonType,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_overview_ml_page.MLOverviewCard, {
  layout: "horizontal",
  path: "/data_drift_index_select",
  title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.selectDataDriftTitle",
    defaultMessage: "Visualize data using data drift",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    "aria-label": _i18n.i18n.translate('xpack.ml.datavisualizer.selector.technicalPreviewBetaBadgeLabel', {
      defaultMessage: 'Technical Preview'
    }),
    iconType: "beaker",
    size: "m",
    color: "hollow",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.dataDriftTechnicalPreviewBadge.titleMsg",
      defaultMessage: "Data drift visualizer is in technical preview.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }),
    tooltipPosition: 'right',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })),
  description: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.dataDriftDescription', {
    defaultMessage: 'Detecting data drifts enables you to identify potential performance issues.'
  }),
  iconType: "visTagCloud",
  buttonLabel: _i18n.i18n.translate('xpack.ml.datavisualizer.selector.selectDataViewButtonLabel', {
    defaultMessage: 'Compare data distribution'
  }),
  cardDataTestSubj: "mlDataVisualizerCardDataDriftData",
  buttonDataTestSubj: "mlDataVisualizerSelectDataDriftButton",
  buttonType: buttonType,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 109,
    columnNumber: 5
  }
}));
exports.DataVisualizerGrid = DataVisualizerGrid;