"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoMapExamples = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/maps-plugin/common");
var _split_cards = require("../split_cards");
var _kibana = require("../../../../../../../contexts/kibana");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _detector_title = require("../detector_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/geo_view/geo_map_examples.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GeoMapExamples = ({
  geoField,
  splitField,
  fieldValues,
  geoAgg,
  layerList
}) => {
  const {
    services: {
      maps: mapsPlugin
    }
  } = (0, _kibana.useMlKibana)();
  const animateSplit = (0, _split_cards.useAnimateSplit)();
  return /*#__PURE__*/_react.default.createElement(_split_cards.SplitCards, {
    fieldValues: fieldValues,
    splitField: splitField,
    numberOfDetectors: fieldValues.length,
    jobType: _new_job.JOB_TYPE.GEO,
    animate: animateSplit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": 'mlGeoMap',
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, geoAgg && geoField ? /*#__PURE__*/_react.default.createElement(_detector_title.DetectorTitle, {
    index: 0,
    agg: geoAgg,
    field: geoField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 35
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }), mapsPlugin && /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "mlGeoJobWizardMap",
    style: {
      width: '100%',
      height: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(mapsPlugin.Map, {
    layerList: layerList,
    hideFilterActions: true,
    mapSettings: {
      initialLocation: _common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
      autoFitToDataBounds: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 17
    }
  }))))));
};
exports.GeoMapExamples = GeoMapExamples;