"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _metric_selector = require("./metric_selector");
var _detector_list = require("./detector_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/advanced_view/metric_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyRichDetector = {
  agg: null,
  field: null,
  byField: null,
  overField: null,
  partitionField: null,
  excludeFrequent: null,
  description: null,
  customRules: null,
  useNull: null
};
const AdvancedDetectors = ({
  setIsValid
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const {
    fields,
    aggs
  } = (0, _new_job_capabilities_service.useNewJobCapsService)();
  const [modalPayload, setModalPayload] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    setIsValid(jobCreator.detectors.length > 0);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function closeModal() {
    setModalPayload(null);
  }
  function detectorChangeHandler(dtr, index) {
    if (index === undefined) {
      jobCreator.addDetector(dtr.agg, dtr.field, dtr.byField, dtr.overField, dtr.partitionField, dtr.excludeFrequent, dtr.description, dtr.useNull);
    } else {
      jobCreator.editDetector(dtr.agg, dtr.field, dtr.byField, dtr.overField, dtr.partitionField, dtr.excludeFrequent, dtr.description, index, dtr.useNull);
    }
    jobCreatorUpdate();
    setModalPayload(null);
  }
  function showModal() {
    setModalPayload({
      detector: emptyRichDetector
    });
  }
  function onDeleteJob(i) {
    jobCreator.removeDetector(i);
    jobCreatorUpdate();
  }
  function onEditJob(i) {
    const dtr = jobCreator.richDetectors[i];
    if (dtr !== undefined) {
      setModalPayload({
        detector: dtr,
        index: i
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_detector_list.DetectorList, {
    isActive: true,
    onEditJob: onEditJob,
    onDeleteJob: onDeleteJob,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_metric_selector.MetricSelector, {
    payload: modalPayload,
    fields: fields,
    aggs: aggs,
    detectorChangeHandler: detectorChangeHandler,
    showModal: showModal,
    closeModal: closeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }));
};
exports.AdvancedDetectors = AdvancedDetectors;