"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationPanel = NavigationPanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
var _validated_range = require("../../components/validated_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/map_settings_panel/navigation_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
const initialLocationOptions = [{
  id: _constants.INITIAL_LOCATION.LAST_SAVED_LOCATION,
  label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.lastSavedLocationLabel', {
    defaultMessage: 'Map location at save'
  })
}, {
  id: _constants.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
  label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.autoFitToBoundsLocationLabel', {
    defaultMessage: 'Auto fit map to data bounds'
  })
}, {
  id: _constants.INITIAL_LOCATION.FIXED_LOCATION,
  label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.fixedLocationLabel', {
    defaultMessage: 'Fixed location'
  })
}, {
  id: _constants.INITIAL_LOCATION.BROWSER_LOCATION,
  label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.browserLocationLabel', {
    defaultMessage: 'Browser location'
  })
}];
function NavigationPanel({
  center,
  settings,
  updateMapSetting,
  zoom
}) {
  const onAutoFitToDataBoundsChange = event => {
    updateMapSetting('autoFitToDataBounds', event.target.checked);
  };
  const onZoomChange = value => {
    const minZoom = Math.max(_constants.MIN_ZOOM, parseInt(value[0], 10));
    const maxZoom = Math.min(_constants.MAX_ZOOM, parseInt(value[1], 10));
    updateMapSetting('minZoom', minZoom);
    updateMapSetting('maxZoom', maxZoom);

    // ensure fixed zoom and browser zoom stay within defined min/max
    if (settings.fixedLocation.zoom < minZoom) {
      onFixedZoomChange(minZoom);
    } else if (settings.fixedLocation.zoom > maxZoom) {
      onFixedZoomChange(maxZoom);
    }
    if (settings.browserLocation.zoom < minZoom) {
      onBrowserZoomChange(minZoom);
    } else if (settings.browserLocation.zoom > maxZoom) {
      onBrowserZoomChange(maxZoom);
    }
  };
  const onInitialLocationChange = optionId => {
    updateMapSetting('initialLocation', optionId);
  };
  const onFixedLatChange = event => {
    let value = parseFloat(event.target.value);
    if (isNaN(value)) {
      value = 0;
    } else if (value < -90) {
      value = -90;
    } else if (value > 90) {
      value = 90;
    }
    updateMapSetting('fixedLocation', {
      ...settings.fixedLocation,
      lat: value
    });
  };
  const onFixedLonChange = event => {
    let value = parseFloat(event.target.value);
    if (isNaN(value)) {
      value = 0;
    } else if (value < -180) {
      value = -180;
    } else if (value > 180) {
      value = 180;
    }
    updateMapSetting('fixedLocation', {
      ...settings.fixedLocation,
      lon: value
    });
  };
  const onFixedZoomChange = value => {
    updateMapSetting('fixedLocation', {
      ...settings.fixedLocation,
      zoom: value
    });
  };
  const onBrowserZoomChange = value => {
    updateMapSetting('browserLocation', {
      zoom: value
    });
  };
  const useCurrentView = () => {
    updateMapSetting('fixedLocation', {
      lat: center.lat,
      lon: center.lon,
      zoom: Math.round(zoom)
    });
  };
  function renderInitialLocationInputs() {
    if (settings.initialLocation === _constants.INITIAL_LOCATION.LAST_SAVED_LOCATION || settings.initialLocation === _constants.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS) {
      return null;
    }
    const zoomFormRow = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.initialZoomLabel', {
        defaultMessage: 'Initial zoom'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
      min: settings.minZoom,
      max: settings.maxZoom,
      step: 1,
      value: settings.initialLocation === _constants.INITIAL_LOCATION.BROWSER_LOCATION ? settings.browserLocation.zoom : settings.fixedLocation.zoom,
      onChange: settings.initialLocation === _constants.INITIAL_LOCATION.BROWSER_LOCATION ? onBrowserZoomChange : onFixedZoomChange,
      showInput: true,
      showRange: true,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }));
    if (settings.initialLocation === _constants.INITIAL_LOCATION.BROWSER_LOCATION) {
      return zoomFormRow;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.initialLatLabel', {
        defaultMessage: 'Initial latitude'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: settings.fixedLocation.lat,
      onChange: onFixedLatChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.initialLonLabel', {
        defaultMessage: 'Initial longitude'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: settings.fixedLocation.lon,
      onChange: onFixedLonChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 11
      }
    })), zoomFormRow, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: useCurrentView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mapSettingsPanel.useCurrentViewBtnLabel",
      defaultMessage: "Set to current view",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 15
      }
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.mapSettingsPanel.navigationTitle",
    defaultMessage: "Navigation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.autoFitToDataBoundsLabel', {
      defaultMessage: 'Auto fit map to data bounds'
    }),
    checked: settings.autoFitToDataBounds,
    onChange: onAutoFitToDataBoundsChange,
    compressed: true,
    "data-test-subj": "autoFitToDataBoundsSwitch",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
    label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.zoomRangeLabel', {
      defaultMessage: 'Zoom range'
    }),
    formRowDisplay: "columnCompressed",
    min: _constants.MIN_ZOOM,
    max: _constants.MAX_ZOOM,
    value: [settings.minZoom, settings.maxZoom],
    showInput: "inputWithPopover",
    showRange: true,
    showLabels: true,
    onChange: onZoomChange,
    allowEmptyRange: false,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.source.mapSettingsPanel.initialLocationLabel', {
      defaultMessage: 'Initial map location'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: initialLocationOptions,
    idSelected: settings.initialLocation,
    onChange: onInitialLocationChange,
    name: "initialMapLocation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  })), renderInitialLocationInputs());
}