"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyleLegend = VectorStyleLegend;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _style_error = require("./style_error");
var _constants = require("../../../../../../common/constants");
var _mask_legend = require("./mask_legend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/vector_style_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const vectorStyleLegendStyles = {
  spacer: ({
    euiTheme
  }) => (0, _react2.css)({
    '&:not(:last-child)': {
      marginBottom: euiTheme.size.s
    }
  }),
  li: ({
    euiTheme
  }) => (0, _react2.css)({
    marginLeft: euiTheme.size.s
  })
};
function VectorStyleLegend({
  isLinesOnly,
  isPointsOnly,
  masks,
  styles,
  symbolId,
  svg
}) {
  const legendRows = [];
  const cssStyles = (0, _use_memo_css.useMemoCss)(vectorStyleLegendStyles);
  for (let i = 0; i < styles.length; i++) {
    const styleMetaDataRequest = styles[i].isDynamic() ? styles[i].getStyleMetaDataRequest() : undefined;
    const error = styleMetaDataRequest === null || styleMetaDataRequest === void 0 ? void 0 : styleMetaDataRequest.getError();
    const row = error ? /*#__PURE__*/_react.default.createElement(_style_error.StyleError, {
      error: error,
      style: styles[i],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }) : styles[i].renderLegendDetailRow({
      isLinesOnly,
      isPointsOnly,
      symbolId,
      svg
    });
    legendRows.push(/*#__PURE__*/_react.default.createElement("div", {
      key: i,
      css: cssStyles.spacer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, row));
  }
  function renderMasksByFieldOrigin(fieldOrigin) {
    const masksByFieldOrigin = masks.filter(mask => mask.getEsAggField().getOrigin() === fieldOrigin);
    if (masksByFieldOrigin.length === 0) {
      return null;
    }
    if (masksByFieldOrigin.length === 1) {
      const mask = masksByFieldOrigin[0];
      return /*#__PURE__*/_react.default.createElement(_mask_legend.MaskLegend, {
        key: mask.getEsAggField().getMbFieldName(),
        esAggField: mask.getEsAggField(),
        operator: mask.getOperator(),
        value: mask.getValue(),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "left",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, masksByFieldOrigin[0].getFieldOriginListLabel())), /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, masksByFieldOrigin.map(mask => /*#__PURE__*/_react.default.createElement("li", {
      key: mask.getEsAggField().getMbFieldName(),
      css: cssStyles.li,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_mask_legend.MaskLegend, {
      esAggField: mask.getEsAggField(),
      onlyShowLabelAndValue: true,
      operator: mask.getOperator(),
      value: mask.getValue(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderMasksByFieldOrigin(_constants.FIELD_ORIGIN.SOURCE), renderMasksByFieldOrigin(_constants.FIELD_ORIGIN.JOIN), legendRows);
}