"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderAsSelect = RenderAsSelect;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _kibana_services = require("../../../../kibana_services");
var _licensed_features = require("../../../../licensed_features");
var _i18n_constants = require("./i18n_constants");
var _show_as_label = require("./show_as_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_grid_source/render_as_select/render_as_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RenderAsSelect(props) {
  if (props.renderAs === _constants.RENDER_AS.HEATMAP) {
    return null;
  }
  let isHexDisabled = false;
  let hexDisabledReason = '';
  if (!(0, _kibana_services.getIsCloud)() && !(0, _licensed_features.getIsGoldPlus)()) {
    isHexDisabled = true;
    hexDisabledReason = _i18n.i18n.translate('xpack.maps.hexbin.license.disabledReason', {
      defaultMessage: '{hexLabel} is a subscription feature.',
      values: {
        hexLabel: _i18n_constants.HEX_LABEL
      }
    });
  }
  const options = [{
    id: _constants.RENDER_AS.POINT,
    label: _i18n_constants.CLUSTER_LABEL,
    value: _constants.RENDER_AS.POINT
  }, {
    id: _constants.RENDER_AS.GRID,
    label: _i18n_constants.GRID_LABEL,
    value: _constants.RENDER_AS.GRID
  }, {
    id: _constants.RENDER_AS.HEX,
    label: _i18n_constants.HEX_LABEL,
    value: _constants.RENDER_AS.HEX,
    isDisabled: isHexDisabled
  }];
  function onChange(id) {
    const data = options.find(option => option.id === id);
    if (data) {
      props.onChange(data.value);
    }
  }
  const currentOption = options.find(option => option.value === props.renderAs) || options[0];
  const selectLabel = /*#__PURE__*/_react.default.createElement(_show_as_label.ShowAsLabel, {
    isHexDisabled: isHexDisabled,
    hexDisabledReason: hexDisabledReason,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: selectLabel,
    display: props.isColumnCompressed ? 'columnCompressed' : 'row',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "single",
    legend: _i18n.i18n.translate('xpack.maps.source.esGeoGrid.showAsSelector', {
      defaultMessage: 'Choose the display method'
    }),
    options: options,
    idSelected: currentOption.id,
    onChange: onChange,
    isFullWidth: true,
    buttonSize: "compressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
}