"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LinksEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _content_management = require("../../../common/content_management");
var _links_editor_tools = require("../../editor/links_editor_tools");
var _open_link_editor_flyout = require("../../editor/open_link_editor_flyout");
var _resolve_links = require("../../lib/resolve_links");
var _kibana_services = require("../../services/kibana_services");
var _links_strings = require("../links_strings");
var _tooltip_wrapper = require("../tooltip_wrapper");
var _links_editor_empty_prompt = require("./links_editor_empty_prompt");
var _links_editor_single_link = require("./links_editor_single_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/editor/links_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const layoutOptions = [{
  id: _content_management.LINKS_VERTICAL_LAYOUT,
  label: _links_strings.LinksStrings.editor.panelEditor.getVerticalLayoutLabel(),
  'data-test-subj': `links--panelEditor--${_content_management.LINKS_VERTICAL_LAYOUT}LayoutBtn`
}, {
  id: _content_management.LINKS_HORIZONTAL_LAYOUT,
  label: _links_strings.LinksStrings.editor.panelEditor.getHorizontalLayoutLabel(),
  'data-test-subj': `links--panelEditor--${_content_management.LINKS_HORIZONTAL_LAYOUT}LayoutBtn`
}];
const LinksEditor = ({
  onSaveToLibrary,
  onAddToDashboard,
  onClose,
  initialLinks,
  initialLayout,
  parentDashboardId,
  isByReference,
  flyoutId
}) => {
  const toasts = _kibana_services.coreServices.notifications.toasts;
  const isMounted = (0, _useMountedState.default)();
  const editLinkFlyoutRef = (0, _react.useRef)(null);
  const [currentLayout, setCurrentLayout] = (0, _react.useState)(initialLayout !== null && initialLayout !== void 0 ? initialLayout : _content_management.LINKS_VERTICAL_LAYOUT);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [orderedLinks, setOrderedLinks] = (0, _react.useState)([]);
  const [saveByReference, setSaveByReference] = (0, _react.useState)(isByReference);
  const isEditingExisting = initialLinks || isByReference;
  (0, _react.useEffect)(() => {
    if (!initialLinks) {
      setOrderedLinks([]);
      return;
    }
    setOrderedLinks((0, _resolve_links.getOrderedLinkList)(initialLinks));
  }, [initialLinks]);
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      const newList = (0, _eui.euiDragDropReorder)(orderedLinks, source.index, destination.index).map((link, i) => {
        return {
          ...link,
          order: i
        };
      });
      setOrderedLinks(newList);
    }
  }, [orderedLinks]);
  const addOrEditLink = (0, _react.useCallback)(async linkToEdit => {
    const newLink = await (0, _open_link_editor_flyout.openLinkEditorFlyout)({
      parentDashboardId,
      link: linkToEdit,
      mainFlyoutId: flyoutId,
      ref: editLinkFlyoutRef
    });
    if (newLink) {
      if (linkToEdit) {
        setOrderedLinks(orderedLinks.map(link => {
          if (link.id === linkToEdit.id) {
            return {
              ...newLink,
              order: linkToEdit.order
            };
          }
          return link;
        }));
      } else {
        setOrderedLinks([...orderedLinks, {
          ...newLink,
          order: orderedLinks.length
        }]);
      }
    }
  }, [editLinkFlyoutRef, orderedLinks, parentDashboardId, flyoutId]);
  const hasZeroLinks = (0, _react.useMemo)(() => {
    return orderedLinks.length === 0;
  }, [orderedLinks]);
  const deleteLink = (0, _react.useCallback)(linkId => {
    setOrderedLinks(orderedLinks.filter(link => {
      return link.id !== linkId;
    }));
    (0, _links_editor_tools.focusMainFlyout)(flyoutId);
  }, [orderedLinks, flyoutId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.flyoutStyles,
    ref: editLinkFlyoutRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "links--panelEditor--title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, isEditingExisting ? _links_strings.LinksStrings.editor.panelEditor.getEditFlyoutTitle() : _links_strings.LinksStrings.editor.panelEditor.getCreateFlyoutTitle()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: styles.bodyStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.panelEditor.getLayoutSettingsTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: layoutOptions,
    buttonSize: "compressed",
    idSelected: currentLayout,
    onChange: id => {
      setCurrentLayout(id);
    },
    legend: _links_strings.LinksStrings.editor.panelEditor.getLayoutSettingsLegend(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.panelEditor.getLinksTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, hasZeroLinks ? /*#__PURE__*/_react.default.createElement(_links_editor_empty_prompt.LinksEditorEmptyPrompt, {
    addLink: () => addOrEditLink(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    css: styles.droppableStyles,
    droppableId: "linksDroppableLinksArea",
    "data-test-subj": "links--panelEditor--linksAreaDroppable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 21
    }
  }, orderedLinks.map((link, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    index: idx,
    key: link.id,
    draggableId: link.id,
    customDragHandle: true,
    hasInteractiveChildren: true,
    "data-test-subj": `links--panelEditor--draggableLink`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 25
    }
  }, provided => {
    var _provided$dragHandleP;
    return /*#__PURE__*/_react.default.createElement(_links_editor_single_link.LinksEditorSingleLink, {
      link: link,
      editLink: () => addOrEditLink(link),
      deleteLink: () => deleteLink(link.id),
      dragHandleProps: (_provided$dragHandleP = provided.dragHandleProps) !== null && _provided$dragHandleP !== void 0 ? _provided$dragHandleP : undefined // casting `null` to `undefined`
      ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 29
      }
    });
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "plusInCircle",
    onClick: () => addOrEditLink(),
    "data-test-subj": "links--panelEditor--addLinkBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 19
    }
  }, _links_strings.LinksStrings.editor.getAddButtonLabel())))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "links--panelEditor--closeBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 13
    }
  }, _links_strings.LinksStrings.editor.getCancelButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }, !initialLinks || !isByReference ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    condition: !hasZeroLinks,
    tooltipContent: _links_strings.LinksStrings.editor.panelEditor.getSaveToLibrarySwitchTooltip(),
    "data-test-subj": "links--panelEditor--saveByReferenceTooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _links_strings.LinksStrings.editor.panelEditor.getSaveToLibrarySwitchLabel(),
    checked: saveByReference,
    disabled: hasZeroLinks,
    onChange: () => setSaveByReference(!saveByReference),
    "data-test-subj": "links--panelEditor--saveByReferenceSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 21
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    condition: hasZeroLinks,
    tooltipContent: _links_strings.LinksStrings.editor.panelEditor.getEmptyLinksTooltip(),
    "data-test-id": 'links--panelEditor--saveBtnTooltip',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: isSaving,
    disabled: hasZeroLinks,
    "data-test-subj": 'links--panelEditor--saveBtn',
    onClick: async () => {
      if (saveByReference) {
        setIsSaving(true);
        onSaveToLibrary(orderedLinks, currentLayout).catch(e => {
          toasts.addError(e, {
            title: _links_strings.LinksStrings.editor.panelEditor.getErrorDuringSaveToastTitle()
          });
        }).finally(() => {
          if (isMounted()) {
            setIsSaving(false);
          }
        });
      } else {
        onAddToDashboard(orderedLinks, currentLayout);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 19
    }
  }, _links_strings.LinksStrings.editor.panelEditor.getSaveButtonLabel()))))))));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.LinksEditor = LinksEditor;
var _default = exports.default = LinksEditor;
const styles = {
  droppableStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    margin: `0 -${euiTheme.size.xs}`
  }),
  bodyStyles: (0, _react2.css)({
    // EUI TODO: We need to set transform to 'none' to avoid drag/drop issues in the flyout caused by the
    // `transform: translateZ(0)` workaround for the mask image bug in Chromium.
    // https://github.com/elastic/eui/pull/7855.
    '& .euiFlyoutBody__overflow': {
      transform: 'none'
    }
  }),
  flyoutStyles: ({
    euiTheme
  }) => {
    const euiFlyoutOpenAnimation = (0, _react2.keyframes)`
    0% {
      opacity: 0;
      transform: translateX(100%);
    }

    100% {
      opacity: 1;
      transform: translateX(0%);
    }
  `;
    const euiFlyoutCloseAnimation = (0, _react2.keyframes)`
    0% {
      opacity: 1;
      transform: translateX(0%);
    }

    100% {
      opacity: 0;
      transform: translateX(100%);
    }`;
    return (0, _react2.css)({
      '.linkEditor': {
        maxInlineSize: `calc(${euiTheme.size.xs} * 125)`,
        height: 'var(--kbn-application--content-height)',
        position: 'fixed',
        display: 'flex',
        inlineSize: '50vw',
        zIndex: euiTheme.levels.flyout,
        alignItems: 'stretch',
        flexDirection: 'column',
        borderLeft: euiTheme.border.thin,
        background: euiTheme.colors.backgroundBasePlain,
        minWidth: `calc((${euiTheme.size.xl} * 13) + ${euiTheme.size.s})`,
        // 424px
        '&.in': {
          animation: `${euiFlyoutOpenAnimation} ${euiTheme.animation.normal} ${euiTheme.animation.resistance}`
        },
        '&.out': {
          animation: `${euiFlyoutCloseAnimation} ${euiTheme.animation.normal} ${euiTheme.animation.resistance}`
        }
      }
    });
  }
};