"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FillOpacityOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/toolbar/appearance_settings/fill_opacity_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FillOpacityOption = ({
  onChange,
  value,
  isFillOpacityEnabled = true
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value,
    onChange
  });
  return isFillOpacityEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.areaFillOpacityLabel', {
      defaultMessage: 'Area fill opacity'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    "data-test-subj": "lnsFillOpacity",
    value: inputValue,
    min: 0.1,
    max: 1,
    step: 0.1,
    showInput: true,
    compressed: true,
    fullWidth: true,
    onChange: e => {
      handleInputChange(Number(e.currentTarget.value));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }))) : null;
};
exports.FillOpacityOption = FillOpacityOption;