"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLensAlertRule = isLensAlertRule;
exports.isLensBrushEvent = isLensBrushEvent;
exports.isLensEditEvent = isLensEditEvent;
exports.isLensFilterEvent = isLensFilterEvent;
exports.isLensMultiFilterEvent = isLensMultiFilterEvent;
exports.isLensTableRowContextMenuClickEvent = isLensTableRowContextMenuClickEvent;
exports.isOperation = isOperation;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isLensFilterEvent(event) {
  return event.name === 'filter';
}
function isLensMultiFilterEvent(event) {
  return event.name === 'multiFilter';
}
function isLensBrushEvent(event) {
  return event.name === 'brush';
}
function isLensEditEvent(event) {
  return event.name === 'edit';
}
function isLensTableRowContextMenuClickEvent(event) {
  return event.name === 'tableRowContextMenuClick';
}
function isLensAlertRule(event) {
  return event.name === 'alertRule';
}
function isOperation(operationCandidate) {
  return typeof operationCandidate === 'object' && operationCandidate !== null && 'columnId' in operationCandidate;
}