"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapseSetting = CollapseSetting;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/collapse_setting.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const options = [{
  text: _i18n.i18n.translate('xpack.lens.collapse.none', {
    defaultMessage: 'None'
  }),
  value: ''
}, {
  text: _i18n.i18n.translate('xpack.lens.collapse.sum', {
    defaultMessage: 'Sum'
  }),
  value: 'sum'
}, {
  text: _i18n.i18n.translate('xpack.lens.collapse.min', {
    defaultMessage: 'Min'
  }),
  value: 'min'
}, {
  text: _i18n.i18n.translate('xpack.lens.collapse.max', {
    defaultMessage: 'Max'
  }),
  value: 'max'
}, {
  text: _i18n.i18n.translate('xpack.lens.collapse.avg', {
    defaultMessage: 'Average'
  }),
  value: 'avg'
}];
function CollapseSetting({
  value,
  onChange,
  display
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "lns-indexPattern-collapse-by",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      delay: "long",
      position: "top",
      content: _i18n.i18n.translate('xpack.lens.collapse.infoIcon', {
        defaultMessage: 'Do not show this dimension in the visualization and aggregate all metric values which have the same value for this dimension into a single number.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.lens.collapse.label', {
      defaultMessage: 'Collapse by'
    }), '', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued",
      size: "s",
      className: "eui-alignTop",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 15
      }
    }))),
    display: display !== null && display !== void 0 ? display : 'rowCompressed',
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "indexPattern-collapse-by",
    options: options,
    value: value,
    onChange: e => {
      onChange(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}