"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpressionRendererParams = getExpressionRendererParams;
var _interpreter = require("@kbn/interpreter");
var _lodash = require("lodash");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _types_guards = require("../../types_guards");
var _variables = require("./variables");
var _merged_search_context = require("./merged_search_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getExpressionFromDocument(document, documentToExpression, forceDSL) {
  const {
    ast,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState,
    activeDatasourceState
  } = await documentToExpression(document, forceDSL);
  return {
    expression: ast ? (0, _interpreter.toExpression)(ast) : null,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState,
    activeDatasourceState
  };
}
function buildHasCompatibleActions(api, {
  uiActions
}) {
  return async event => {
    if (!(uiActions !== null && uiActions !== void 0 && uiActions.getTriggerCompatibleActions)) {
      return false;
    }
    if ((0, _types_guards.isLensTableRowContextMenuClickEvent)(event) || (0, _types_guards.isLensMultiFilterEvent)(event) || (0, _types_guards.isLensFilterEvent)(event)) {
      const actions = await uiActions.getTriggerCompatibleActions(_public.VIS_EVENT_TO_TRIGGER[event.name], {
        data: event.data,
        embeddable: api
      });
      return actions.length > 0;
    }
    return false;
  };
}
function buildGetCompatibleCellValueActions(api, {
  uiActions
}) {
  return async data => {
    if (!(uiActions !== null && uiActions !== void 0 && uiActions.getTriggerCompatibleActions)) {
      return [];
    }
    const actions = await uiActions.getTriggerCompatibleActions(_public2.CELL_VALUE_TRIGGER, {
      data,
      embeddable: api
    });
    return actions.sort((a, b) => {
      var _a$order, _b$order;
      return ((_a$order = a.order) !== null && _a$order !== void 0 ? _a$order : Infinity) - ((_b$order = b.order) !== null && _b$order !== void 0 ? _b$order : Infinity);
    }).map(action => ({
      id: action.id,
      type: action.type,
      iconType: action.getIconType({
        embeddable: api,
        data,
        trigger: _public2.cellValueTrigger
      }),
      displayName: action.getDisplayName({
        embeddable: api,
        data,
        trigger: _public2.cellValueTrigger
      }),
      execute: cellData => action.execute({
        embeddable: api,
        data: cellData,
        trigger: _public2.cellValueTrigger
      })
    }));
  };
}
async function getExpressionRendererParams(state, {
  settings: {
    syncColors = true,
    syncCursor = true,
    syncTooltips = false
  },
  services,
  disableTriggers = false,
  getExecutionContext,
  searchSessionId,
  abortController,
  onRender,
  handleEvent,
  onData = _lodash.noop,
  logError,
  api,
  renderMode,
  addUserMessages,
  updateBlockingErrors,
  searchContext,
  forceDSL,
  getDisplayOptions
}) {
  const {
    expressionRenderer,
    documentToExpression
  } = services;
  const {
    expression,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState,
    activeDatasourceState
  } = await getExpressionFromDocument(state.attributes, documentToExpression, forceDSL);

  // Apparently this change produces had lots of issues with solutions not using
  // the Embeddable incorrectly. Will comment for now and later on will restore it when
  // https://github.com/elastic/kibana/issues/200236 is resolved
  //
  // if at least one indexPattern is time based, then the Lens embeddable requires the timeRange prop
  // this is necessary for the dataview embeddable but not the ES|QL one
  // if (
  //   isSearchContextIncompatibleWithDataViews(
  //     api,
  //     getExecutionContext(),
  //     searchContext,
  //     indexPatternRefs,
  //     indexPatterns
  //   )
  // ) {
  //   addUserMessages([getSearchContextIncompatibleMessage()]);
  // }

  if (expression) {
    const params = {
      expression,
      syncColors,
      syncCursor,
      syncTooltips,
      searchSessionId,
      onRender$: onRender,
      renderMode,
      handleEvent,
      onData$: onData,
      // Remove ES|QL query from it
      searchContext: (0, _merged_search_context.getExecutionSearchContext)(searchContext),
      interactive: !disableTriggers,
      executionContext: getExecutionContext(),
      lensInspector: {
        getInspectorAdapters: api.getInspectorAdapters,
        inspect: api.inspect,
        closeInspector: api.closeInspector
      },
      ExpressionRenderer: expressionRenderer,
      addUserMessages,
      onRuntimeError: error => {
        updateBlockingErrors(error);
        logError('runtime');
      },
      abortController,
      hasCompatibleActions: buildHasCompatibleActions(api, services),
      getCompatibleCellValueActions: buildGetCompatibleCellValueActions(api, services),
      variables: (0, _variables.getVariables)(api, state),
      style: state.style,
      className: state.className,
      noPadding: getDisplayOptions().noPadding
    };
    return {
      indexPatterns,
      indexPatternRefs,
      activeVisualizationState,
      activeDatasourceState,
      params,
      abortController
    };
  }
  return {
    params: null,
    abortController,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState,
    activeDatasourceState
  };
}