"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.movingAverageOperation = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _shared_components = require("../../../../../shared_components");
var _utils = require("./utils");
var _layer_helpers = require("../../layer_helpers");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/calculations/moving_average.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ofName = (0, _utils.buildLabelFunction)(name => {
  return _i18n.i18n.translate('xpack.lens.indexPattern.movingAverageOf', {
    defaultMessage: 'Moving average of {name}',
    values: {
      name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
        defaultMessage: '(incomplete)'
      })
    }
  });
});
const movingAverageOperation = exports.movingAverageOperation = {
  type: _lensFormulaDocs.MOVING_AVERAGE_ID,
  priority: 1,
  displayName: _lensFormulaDocs.MOVING_AVERAGE_NAME,
  input: 'fullReference',
  selectionStyle: 'full',
  requiredReferences: [{
    input: ['field', 'managedReference'],
    validateMetadata: meta => meta.dataType === 'number' && !meta.isBucketed
  }],
  operationParams: [{
    name: 'window',
    type: 'number',
    required: false,
    defaultValue: _lensFormulaDocs.MOVING_AVERAGE_WINDOW_DEFAULT_VALUE
  }],
  getPossibleOperation: indexPattern => {
    if ((0, _utils.hasDateField)(indexPattern)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  getDefaultLabel: (column, columns, indexPattern) => {
    var _columns$column$refer;
    return ofName((_columns$column$refer = columns[column.references[0]]) === null || _columns$column$refer === void 0 ? void 0 : _columns$column$refer.label, column.timeScale, column.timeShift);
  },
  toExpression: (layer, columnId) => {
    return (0, _utils.dateBasedOperationToExpression)(layer, columnId, 'moving_average', {
      window: [layer.columns[columnId].params.window]
    });
  },
  buildColumn: ({
    referenceIds,
    previousColumn,
    layer
  }, columnParams) => {
    var _columnParams$window;
    const metric = layer.columns[referenceIds[0]];
    const window = (_columnParams$window = columnParams === null || columnParams === void 0 ? void 0 : columnParams.window) !== null && _columnParams$window !== void 0 ? _columnParams$window : _lensFormulaDocs.MOVING_AVERAGE_WINDOW_DEFAULT_VALUE;
    return {
      label: ofName(metric === null || metric === void 0 ? void 0 : metric.label, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      dataType: 'number',
      operationType: 'moving_average',
      isBucketed: false,
      references: referenceIds,
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeScale: previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale,
      params: {
        window,
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn)
      }
    };
  },
  paramEditor: MovingAverageParamEditor,
  isTransferable: (column, newIndexPattern) => {
    return (0, _utils.hasDateField)(newIndexPattern);
  },
  getErrorMessage: (layer, columnId) => {
    return (0, _utils.getErrorsForDateReference)(layer, columnId, _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage', {
      defaultMessage: 'Moving average'
    }));
  },
  helpComponent: () => /*#__PURE__*/_react.default.createElement(MovingAveragePopup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 24
    }
  }),
  helpComponentTitle: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.titleHelp', {
    defaultMessage: 'How moving average works'
  }),
  getDisabledStatus(indexPattern, layer, layerType) {
    const opName = _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage', {
      defaultMessage: 'Moving average'
    });
    if (layerType) {
      const dataLayerErrors = (0, _utils.checkForDataLayerType)(layerType, opName);
      if (dataLayerErrors) {
        return dataLayerErrors.join(', ');
      }
    }
    return (0, _utils.checkForDateHistogram)(layer, opName).map(e => e.message).join(', ');
  },
  timeScalingMode: 'optional',
  filterable: true,
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.documentation.quick', {
    defaultMessage: `
      The average of a moving window of values over time.
      `
  }),
  shiftable: true
};
function MovingAverageParamEditor({
  layer,
  paramEditorUpdater,
  currentColumn,
  columnId
}) {
  const [inputValue, setInputValue] = (0, _react.useState)(String(currentColumn.params.window));
  (0, _shared_components.useDebounceWithOptions)(() => {
    if (!(0, _helpers.isValidNumber)(inputValue, true, undefined, 1)) return;
    const inputNumber = parseInt(inputValue, 10);
    paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
      layer,
      columnId,
      paramName: 'window',
      value: inputNumber
    }));
  }, {
    skipFirstRender: true
  }, 256, [inputValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.window', {
      defaultMessage: 'Window size'
    }),
    display: "rowCompressed",
    fullWidth: true,
    isInvalid: !(0, _helpers.isValidNumber)(inputValue),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    compressed: true,
    value: inputValue,
    onChange: e => setInputValue(e.target.value),
    min: 1,
    step: 1,
    isInvalid: !(0, _helpers.isValidNumber)(inputValue),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }));
}
const MovingAveragePopup = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.basicExplanation",
    defaultMessage: "Moving average slides a window across the data and displays the average value. Moving average is supported only by date histograms.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.longerExplanation",
    defaultMessage: "To calculate the moving average, Lens uses the mean of the window and applies a skip policy for gaps.  For missing values, the bucket is skipped, and the calculation is performed on the next value.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.tableExplanation",
    defaultMessage: "For example, given the data [1, 2, 3, 4, 5, 6, 7, 8, 9, 10], you can calculate a simple moving average with a window size of 5:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, "(1 + 2 + 3 + 4 + 5) / 5 = 3"), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, "(2 + 3 + 4 + 5 + 6) / 5 = 4"), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, "..."), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, "(5 + 6 + 7 + 8 + 9) / 5 = 7")), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.windowLimitations",
    defaultMessage: "The window does not include the current value.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.windowInitialPartial",
    defaultMessage: "The window is partial until it reaches the requested number of items.  For example, with a window size of 5:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }, "(1 + 2) / 2 = 1.5"), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, "(1 + 2 + 3) / 3 = 2"), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }, "(1 + 2 + 3 + 4) / 4 = 2.5"), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, "(1 + 2 + 3 + 4 + 5) / 5 = 3")), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.limitations",
    defaultMessage: "The first moving average value starts at the second item.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  })));
};