"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetLayerTabsLabel = void 0;
var _react = require("react");
var _lensCommon = require("@kbn/lens-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetLayerTabsLabel = layerConfigs => {
  const layerLabels = (0, _react.useMemo)(() => {
    const visibleLayerConfigs = layerConfigs.filter(layer => !layer.config.hidden);
    const countsByLayerId = new Map();
    const typeCounters = new Map();
    const layerTabDisplayNames = new Map();
    for (const config of visibleLayerConfigs) {
      const layerType = config.layerType || '';
      const currentCount = (typeCounters.get(layerType) || 0) + 1;
      typeCounters.set(layerType, currentCount);
      countsByLayerId.set(config.layerId, currentCount);
    }
    for (const config of visibleLayerConfigs) {
      const layerType = config.layerType || '';
      const typeCount = typeCounters.get(layerType) || 0;
      const layerCountForId = countsByLayerId.get(config.layerId) || 1;
      const displayName = (0, _lensCommon.getLensLayerTypeTabDisplayName)(config.layerType, typeCount > 1 ? layerCountForId : undefined);
      layerTabDisplayNames.set(config.layerId, displayName);
    }
    return layerTabDisplayNames;
  }, [layerConfigs]);
  const getLayerTabsLabel = (0, _react.useCallback)(layerId => {
    return layerLabels.get(layerId) || _lensCommon.lensLayerTypeTabDisplayNames.unknown;
  }, [layerLabels]);
  return getLayerTabsLabel;
};
exports.useGetLayerTabsLabel = useGetLayerTabsLabel;