"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_LAYER_TABS_CONTENT_ID = void 0;
exports.LayerTabs = LayerTabs;
exports.LayerTabsWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _unifiedTabs = require("@kbn/unified-tabs");
var _state_management = require("../../../state_management");
var _editor_frame_service_context = require("../../../editor_frame_service/editor_frame_service_context");
var _layer_actions = require("../../../editor_frame_service/editor_frame/config_panel/layer_actions/layer_actions");
var _utils = require("../../../utils");
var _use_layer_tabs_labels = require("./use_layer_tabs_labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/shared/edit_on_the_fly/layer_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LENS_LAYER_TABS_CONTENT_ID = exports.LENS_LAYER_TABS_CONTENT_ID = 'lnsLayerTabsContent';
const LayerTabsWrapper = exports.LayerTabsWrapper = /*#__PURE__*/(0, _react.memo)(function LayerTabsWrapper(props) {
  const {
    visualizationMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const activeVisualization = visualization.activeId ? visualizationMap[visualization.activeId] : null;
  return activeVisualization && visualization.state ? /*#__PURE__*/_react.default.createElement(LayerTabs, (0, _extends2.default)({}, props, {
    activeVisualization: activeVisualization,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  })) : null;
});
function LayerTabs({
  activeVisualization,
  attributes,
  coreStart,
  framePublicAPI,
  uiActions
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    datasourceMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const {
    isSaveable,
    visualization,
    datasourceStates
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const selectedLayerId = (0, _state_management.useLensSelector)(_state_management.selectSelectedLayerId);
  const [datasource] = Object.values(framePublicAPI.datasourceLayers);
  const isTextBasedLanguage = (datasource === null || datasource === void 0 ? void 0 : datasource.isTextBasedLanguage()) || (0, _esQuery.isOfAggregateQueryType)(attributes === null || attributes === void 0 ? void 0 : attributes.state.query) || false;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const layerIds = activeVisualization.getLayerIds(visualization.state);
  const registerLibraryAnnotationGroupFunction = (0, _react.useCallback)(groupInfo => dispatchLens((0, _state_management.registerLibraryAnnotationGroup)(groupInfo)), [dispatchLens]);

  // if the selected tab got removed, switch back first tab
  (0, _react.useEffect)(() => {
    if (selectedLayerId === null || !layerIds.includes(selectedLayerId) && layerIds.length > 0) {
      dispatchLens((0, _state_management.setSelectedLayerId)({
        layerId: layerIds[0]
      }));
    }
  }, [dispatchLens, selectedLayerId, layerIds]);
  const layerConfigs = (0, _react.useMemo)(() => {
    return layerIds.map(layerId => ({
      layerId,
      layerType: activeVisualization.getLayerType(layerId, visualization.state),
      config: activeVisualization.getConfiguration({
        layerId,
        frame: framePublicAPI,
        state: visualization.state
      })
    }));
  }, [activeVisualization, layerIds, framePublicAPI, visualization.state]);

  // Create layer labels for the tabs
  const getLayerTabsLabel = (0, _use_layer_tabs_labels.useGetLayerTabsLabel)(layerConfigs);
  const layerActionsFlyoutRef = (0, _react.useRef)(null);
  const onRemoveLayer = (0, _react.useCallback)(async layerToRemoveId => {
    var _framePublicAPI$datas;
    const datasourcePublicAPI = (_framePublicAPI$datas = framePublicAPI.datasourceLayers) === null || _framePublicAPI$datas === void 0 ? void 0 : _framePublicAPI$datas[layerToRemoveId];
    const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
    if (datasourceId) {
      var _datasourceStates$dat;
      const layerDatasource = datasourceMap[datasourceId];
      const layerDatasourceState = datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state;
      const trigger = uiActions.getTrigger(_public.UPDATE_FILTER_REFERENCES_TRIGGER);
      const action = await uiActions.getAction(_public.UPDATE_FILTER_REFERENCES_ACTION);
      action === null || action === void 0 ? void 0 : action.execute({
        trigger,
        fromDataView: layerDatasource.getUsedDataView(layerDatasourceState, layerToRemoveId),
        usedDataViews: layerDatasource.getLayers(layerDatasourceState).map(layer => layerDatasource.getUsedDataView(layerDatasourceState, layer)),
        defaultDataView: layerDatasource.getUsedDataView(layerDatasourceState)
      });
    }
    dispatchLens((0, _state_management.removeOrClearLayer)({
      visualizationId: activeVisualization.id,
      layerId: layerToRemoveId,
      layerIds
    }));
  }, [activeVisualization.id, datasourceMap, datasourceStates, dispatchLens, layerIds, framePublicAPI.datasourceLayers, uiActions]);
  const visibleLayerConfigs = (0, _react.useMemo)(() => layerConfigs.filter(layer => !layer.config.hidden), [layerConfigs]);
  const managedItems = (0, _react.useMemo)(() => {
    const updateVisualization = newState => {
      dispatchLens((0, _state_management.updateVisualizationState)({
        visualizationId: activeVisualization.id,
        newState
      }));
    };
    const visualizationState = visualization.state;
    return visibleLayerConfigs.map((layerConfig, layerIndex) => {
      var _activeVisualization$, _activeVisualization$2;
      const compatibleActions = [...(((_activeVisualization$ = activeVisualization.getSupportedActionsForLayer) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, layerConfig.layerId, visualizationState, updateVisualization, registerLibraryAnnotationGroupFunction, isSaveable).map(action => ({
        ...action,
        execute: () => {
          action.execute(layerActionsFlyoutRef.current);
        }
      }))) || []), ...(0, _layer_actions.getSharedActions)({
        layerId: layerConfig.layerId,
        activeVisualization,
        core: coreStart,
        layerIndex,
        layerType: activeVisualization.getLayerType(layerConfig.layerId, visualizationState),
        isOnlyLayer: (0, _utils.getRemoveOperation)(activeVisualization, visualization.state, layerConfig.layerId, layerIds.length) === 'clear',
        isTextBasedLanguage,
        onCloneLayer: () => {
          dispatchLens((0, _state_management.cloneLayer)({
            layerId: layerConfig.layerId
          }));
        },
        onRemoveLayer: () => onRemoveLayer(layerConfig.layerId),
        customRemoveModalText: (_activeVisualization$2 = activeVisualization.getCustomRemoveLayerText) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, layerConfig.layerId, visualizationState)
      })].filter(i => i.isCompatible);
      return {
        id: layerConfig.layerId,
        label: getLayerTabsLabel(layerConfig.layerId),
        customMenuButton: /*#__PURE__*/_react.default.createElement(_layer_actions.LayerActions, {
          actions: compatibleActions,
          layerIndex: layerIndex,
          mountingPoint: layerActionsFlyoutRef.current,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 215,
            columnNumber: 11
          }
        })
      };
    });
  }, [activeVisualization, coreStart, dispatchLens, isSaveable, isTextBasedLanguage, layerIds.length, getLayerTabsLabel, onRemoveLayer, registerLibraryAnnotationGroupFunction, visibleLayerConfigs, visualization]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        pointer-events: auto;
        background-color: ${euiTheme.colors.emptyShade};
        border-bottom: ${euiTheme.border.thin};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 5
    }
  }, managedItems.length > 1 ? /*#__PURE__*/_react.default.createElement(_unifiedTabs.UnifiedTabs, {
    items: managedItems,
    selectedItemId: selectedLayerId !== null && selectedLayerId !== void 0 ? selectedLayerId : undefined,
    recentlyClosedItems: [],
    onClearRecentlyClosed: () => {},
    maxItemsCount: 25,
    services: {
      core: {
        chrome: coreStart.chrome
      }
    },
    onChanged: updatedState => {
      var _updatedState$selecte, _updatedState$selecte2;
      // Create a set of the updated item ids for easy lookup
      const updatedItemIds = new Set(updatedState.items.map(item => item.id));

      // Handle removed layers
      managedItems.filter(item => !updatedItemIds.has(item.id)).forEach(item => {
        onRemoveLayer(item.id);
      });

      // Update selected layer
      dispatchLens((0, _state_management.setSelectedLayerId)({
        layerId: (_updatedState$selecte = (_updatedState$selecte2 = updatedState.selectedItem) === null || _updatedState$selecte2 === void 0 ? void 0 : _updatedState$selecte2.id) !== null && _updatedState$selecte !== void 0 ? _updatedState$selecte : null
      }));
    },
    onEBTEvent: () => {}
    // we render the custom "Add layer" button in the flyout header toolbar
    ,
    customNewTabButton: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    createItem: () => ({
      id: '',
      label: ''
    }),
    tabContentIdOverride: LENS_LAYER_TABS_CONTENT_ID,
    disableInlineLabelEditing: true,
    disableDragAndDrop: true,
    disableTabsBarMenu: true,
    disableCloseButton: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement("div", {
    ref: layerActionsFlyoutRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }));
}