"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveModalContainer = SaveModalContainer;
exports.default = void 0;
exports.removePinnedFilters = removePinnedFilters;
exports.runSaveLensVisualization = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _save_modal = require("./save_modal");
var _constants = require("../../common/constants");
var _load_initial = require("../state_management/init_middleware/load_initial");
var _save_modal_container_helpers = require("./save_modal_container_helpers");
var _app_helpers = require("./app_helpers");
var _helper = require("../react_embeddable/helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/save_modal_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SaveModalContainer({
  returnToOriginSwitchLabel,
  onClose,
  onSave,
  runSave,
  persistedDoc,
  originatingApp,
  getOriginatingPath,
  initialInput,
  redirectTo,
  redirectToOrigin,
  getAppNameFromId = () => undefined,
  isSaveable = true,
  lastKnownDoc: initLastKnownDoc,
  lensServices,
  initialContext,
  managed,
  controlsState
}) {
  let title = '';
  let description;
  let savedObjectId;
  const [initializing, setInitializing] = (0, _react.useState)(true);
  const [lastKnownDoc, setLastKnownDoc] = (0, _react.useState)(initLastKnownDoc);
  if (lastKnownDoc) {
    title = lastKnownDoc.title;
    description = lastKnownDoc.description;
    savedObjectId = lastKnownDoc.savedObjectId;
  }
  if (!(lastKnownDoc !== null && lastKnownDoc !== void 0 && lastKnownDoc.title) && (0, _app_helpers.isLegacyEditorEmbeddable)(initialContext)) {
    title = _i18n.i18n.translate('xpack.lens.app.convertedLabel', {
      defaultMessage: '{title} (converted)',
      values: {
        title: initialContext.title || `${initialContext.visTypeTitle} visualization`
      }
    });
  }
  const {
    attributeService,
    savedObjectsTagging,
    application
  } = lensServices;
  (0, _react.useEffect)(() => {
    setLastKnownDoc(initLastKnownDoc);
  }, [initLastKnownDoc]);
  (0, _react.useEffect)(() => {
    let isMounted = true;
    if (initialInput) {
      (0, _load_initial.getFromPreloaded)({
        initialInput,
        lensServices
      }).then(persisted => {
        if (persisted !== null && persisted !== void 0 && persisted.doc && isMounted) setLastKnownDoc(persisted.doc);
      }).finally(() => {
        setInitializing(false);
      });
    } else {
      setInitializing(false);
    }
    return () => {
      isMounted = false;
    };
  }, [initialInput, lensServices]);
  const tagsIds = persistedDoc && savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(persistedDoc.references) : [];
  const runLensSave = async (saveProps, options) => {
    if (runSave) {
      // inside lens, we use the function that's passed to it
      return runSave(saveProps, options);
    }
    if (attributeService && lastKnownDoc) {
      await runSaveLensVisualization({
        ...lensServices,
        lastKnownDoc,
        initialInput,
        redirectTo,
        redirectToOrigin,
        originatingApp,
        getOriginatingPath,
        controlsState,
        onAppLeave: () => {},
        ...lensServices
      }, saveProps, options);
      onSave === null || onSave === void 0 ? void 0 : onSave(saveProps);
      onClose();
    }
  };
  if (initializing) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 12
      }
    });
  }
  const savingToLibraryPermitted = Boolean(isSaveable && application.capabilities.visualize_v2.save);
  return /*#__PURE__*/_react.default.createElement(_save_modal.SaveModal, {
    originatingApp: originatingApp,
    getOriginatingPath: getOriginatingPath,
    savingToLibraryPermitted: savingToLibraryPermitted,
    savedObjectsTagging: savedObjectsTagging,
    tagsIds: tagsIds,
    onSave: async (saveProps, options) => {
      await runLensSave(saveProps, options);
    },
    onClose: onClose,
    getAppNameFromId: getAppNameFromId,
    title: title,
    description: description,
    savedObjectId: savedObjectId,
    returnToOriginSwitchLabel: returnToOriginSwitchLabel,
    returnToOrigin: redirectToOrigin != null,
    managed: Boolean(managed),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  });
}
function fromDocumentToSerializedState(doc, panelSettings, originalInput) {
  return {
    ...originalInput,
    attributes: (0, _lodash.omit)(doc, 'savedObjectId'),
    savedObjectId: doc.savedObjectId,
    ...panelSettings
  };
}
const getDocToSave = (lastKnownDoc, saveProps, references) => {
  const docToSave = {
    ...removePinnedFilters(lastKnownDoc),
    references
  };
  if (saveProps.newDescription !== undefined) {
    docToSave.description = saveProps.newDescription;
  }
  if (saveProps.newTitle !== undefined) {
    docToSave.title = saveProps.newTitle;
  }
  return docToSave;
};
const runSaveLensVisualization = async (props, saveProps, options) => {
  var _initialInput$attribu;
  const {
    chrome,
    initialInput,
    lastKnownDoc,
    persistedDoc,
    notifications,
    stateTransfer,
    attributeService,
    savedObjectsTagging,
    redirectToOrigin,
    onAppLeave,
    redirectTo,
    textBasedLanguageSave,
    switchDatasource,
    application,
    lensDocumentService,
    controlsState
  } = props;
  if (!lastKnownDoc) {
    return;
  }
  let references = lastKnownDoc.references || (initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$attribu = initialInput.attributes) === null || _initialInput$attribu === void 0 ? void 0 : _initialInput$attribu.references);
  if (savedObjectsTagging) {
    const tagsIds = persistedDoc && savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(persistedDoc.references) : [];
    references = savedObjectsTagging.ui.updateTagsReferences(references, saveProps.newTags || tagsIds);
  }
  const docToSave = getDocToSave(lastKnownDoc, saveProps, references);
  const originalInput = saveProps.newCopyOnSave ? undefined : initialInput;
  const originalSavedObjectId = originalInput === null || originalInput === void 0 ? void 0 : originalInput.savedObjectId;
  if (options.saveToLibrary) {
    await lensDocumentService.checkForDuplicateTitle({
      id: originalSavedObjectId,
      title: docToSave.title,
      displayName: _i18n.i18n.translate('xpack.lens.app.saveModalType', {
        defaultMessage: 'Lens visualization'
      }),
      lastSavedTitle: lastKnownDoc.title,
      copyOnSave: saveProps.newCopyOnSave,
      isTitleDuplicateConfirmed: saveProps.isTitleDuplicateConfirmed
    }, saveProps.onTitleDuplicate);
    // ignore duplicate title failure, user notified in save modal
  }
  try {
    var _saveProps$panelTimeR;
    // wrap the doc into a serializable state
    const newDoc = fromDocumentToSerializedState(docToSave, {
      timeRange: (_saveProps$panelTimeR = saveProps.panelTimeRange) !== null && _saveProps$panelTimeR !== void 0 ? _saveProps$panelTimeR : originalInput === null || originalInput === void 0 ? void 0 : originalInput.timeRange,
      savedObjectId: options.saveToLibrary ? originalSavedObjectId : undefined
    }, originalInput);
    let savedObjectId;
    try {
      savedObjectId = newDoc.attributes && options.saveToLibrary ? await attributeService.saveToLibrary(newDoc.attributes, newDoc.attributes.references || [], originalSavedObjectId) : undefined;
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.lens.app.saveVisualization.errorNotificationText', {
          defaultMessage: `An error occurred while saving. Error: {errorMessage}`,
          values: {
            errorMessage: error.message
          }
        })
      });
      // trigger a reject to jump to the final catch clause
      throw error;
    }
    const shouldNavigateBackToOrigin = saveProps.returnToOrigin && redirectToOrigin;
    const hasRedirect = shouldNavigateBackToOrigin || saveProps.dashboardId;

    // if a redirect was set, prevent the validation on app leave
    if (hasRedirect) {
      // disabling the validation on app leave because the document has been saved.
      onAppLeave === null || onAppLeave === void 0 ? void 0 : onAppLeave(actions => {
        return actions.default();
      });
    }
    if (shouldNavigateBackToOrigin) {
      const apiConfig = (0, _helper.transformToApiConfig)({
        ...newDoc,
        savedObjectId
      });
      redirectToOrigin({
        state: apiConfig,
        isCopied: saveProps.newCopyOnSave
      });
      return;
    }
    // should we make it more robust here and better check the context of the saving
    // or keep the responsability of the consumer of the function to provide the right set
    // of args here in case the user is within a by value chart AND want's to save it in the library
    // without redirect?
    if (saveProps.dashboardId) {
      (0, _save_modal_container_helpers.redirectToDashboard)({
        embeddableInput: {
          ...newDoc,
          savedObjectId
        },
        dashboardId: saveProps.dashboardId,
        stateTransfer,
        originatingApp: props.originatingApp,
        getOriginatingPath: props.getOriginatingPath,
        controlsState
      });
      return;
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.lens.app.saveVisualization.successNotificationText', {
      defaultMessage: `Saved ''{visTitle}''`,
      values: {
        visTitle: docToSave.title
      }
    }));
    if (savedObjectId && savedObjectId !== originalSavedObjectId) {
      var _stateTransfer$clearE;
      chrome.recentlyAccessed.add((0, _constants.getFullPath)(savedObjectId), docToSave.title, savedObjectId);

      // remove editor state so the connection is still broken after reload
      (_stateTransfer$clearE = stateTransfer.clearEditorState) === null || _stateTransfer$clearE === void 0 ? void 0 : _stateTransfer$clearE.call(stateTransfer, _constants.APP_ID);
      if (textBasedLanguageSave) {
        switchDatasource === null || switchDatasource === void 0 ? void 0 : switchDatasource();
        application.navigateToApp('lens', {
          path: '/'
        });
      } else {
        redirectTo === null || redirectTo === void 0 ? void 0 : redirectTo(savedObjectId);
      }
      return {
        isLinkedToOriginatingApp: false
      };
    }
    return {
      persistedDoc: newDoc.attributes,
      isLinkedToOriginatingApp: false
    };
  } catch (e) {
    // eslint-disable-next-line no-console
    console.dir(e);
    throw e;
  }
};
exports.runSaveLensVisualization = runSaveLensVisualization;
function removePinnedFilters(doc) {
  var _doc$state;
  if (!doc) return undefined;
  return {
    ...doc,
    state: {
      ...doc.state,
      filters: (((_doc$state = doc.state) === null || _doc$state === void 0 ? void 0 : _doc$state.filters) || []).filter(filter => !(0, _esQuery.isFilterPinned)(filter))
    }
  };
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SaveModalContainer;