"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromPercentileRanksAPItoLensState = exports.fromPercentileRankLensStateToAPI = void 0;
var _utils = require("./utils");
var _format = require("./format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromPercentileRanksAPItoLensState = options => {
  const {
    field,
    rank
  } = options;
  return {
    operationType: 'percentile_rank',
    sourceField: field,
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      value: rank,
      format: (0, _format.fromFormatAPIToLensState)(options.format)
    }
  };
};
exports.fromPercentileRanksAPItoLensState = fromPercentileRanksAPItoLensState;
const fromPercentileRankLensStateToAPI = options => {
  var _options$params, _options$params2;
  return {
    operation: options.operationType,
    field: options.sourceField,
    rank: (_options$params = options.params) === null || _options$params === void 0 ? void 0 : _options$params.value,
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params2 = options.params) !== null && _options$params2 !== void 0 && _options$params2.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromPercentileRankLensStateToAPI = fromPercentileRankLensStateToAPI;