"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_FILTER = void 0;
exports.fromFilterAPIToLensState = fromFilterAPIToLensState;
exports.fromFilterLensStateToAPI = fromFilterLensStateToAPI;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromFilterAPIToLensState(filter) {
  if (!filter) {
    return;
  }
  return filter;
}
function fromFilterLensStateToAPI(filter) {
  if (typeof filter.query !== 'string') {
    return;
  }
  return {
    query: filter.query,
    language: filter.language
  };
}
const DEFAULT_FILTER = exports.DEFAULT_FILTER = {
  query: '*',
  language: 'kuery'
};